/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoController;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjEntityRelationshipTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjRelationshipListener,
ExistingSelectionProcessor {
    private static Log logObj = LogFactory.getLog(ObjEntityRelationshipTab.class);
    private static final Object[] deleteRules = new Object[]{DeleteRule.deleteRuleName((int)0), DeleteRule.deleteRuleName((int)1), DeleteRule.deleteRuleName((int)2), DeleteRule.deleteRuleName((int)3)};
    ProjectController mediator;
    CayenneTable table;
    JButton resolve;

    public ObjEntityRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateRelationshipAction.getActionName()).buildButton());
        toolBar.add(app.getAction(ObjEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        this.resolve = new JButton();
        this.resolve.setIcon(ModelerUtil.buildIcon("icon-info.gif"));
        this.resolve.setToolTipText("Edit Relationship");
        toolBar.add(this.resolve);
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveRelationshipAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new StringRenderer());
        this.table.setDefaultRenderer(ObjEntity.class, new EntityRenderer());
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjRelationshipListener(this);
        this.resolve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ObjEntityRelationshipTab.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ObjRelationshipTableModel model = (ObjRelationshipTableModel)ObjEntityRelationshipTab.this.table.getModel();
                new ObjRelationshipInfoController(ObjEntityRelationshipTab.this.mediator, model.getRelationship(row)).startup();
                ObjEntityRelationshipTab.this.table.getSelectionModel().clearSelection();
                ObjEntityRelationshipTab.this.table.select(row);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjEntityRelationshipTab.this.processExistingSelection(e);
            }
        });
    }

    public void selectRelationship(ObjRelationship rel) {
        if (rel == null) {
            Application.getInstance().getAction(RemoveRelationshipAction.getActionName()).setEnabled(false);
            return;
        }
        Application.getInstance().getAction(RemoveRelationshipAction.getActionName()).setEnabled(true);
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        List rels = model.getObjectList();
        int relPos = rels.indexOf(rel);
        if (relPos >= 0) {
            this.table.select(relPos);
        }
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        ObjRelationship rel = null;
        if (this.table.getSelectedRow() >= 0) {
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
            rel = model.getRelationship(this.table.getSelectedRow());
            if (rel.getTargetEntity() != null && ((ObjEntity)rel.getSourceEntity()).getDbEntity() != null && ((ObjEntity)rel.getTargetEntity()).getDbEntity() != null) {
                this.resolve.setEnabled(true);
            } else {
                this.resolve.setEnabled(false);
            }
            UIUtil.scrollToSelectedRow(this.table);
        } else {
            this.resolve.setEnabled(false);
        }
        RelationshipDisplayEvent ev = new RelationshipDisplayEvent((Object)this, (Relationship)rel, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjRelationshipDisplayEvent(ev);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    private Object[] createObjEntityComboModel() {
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            logObj.warn((Object)"createObjEntityComboModel:: Null DataMap.");
            return new Object[0];
        }
        if (map.getNamespace() == null) {
            logObj.warn((Object)("createObjEntityComboModel:: Null DataMap namespace - " + map));
            return new Object[0];
        }
        Collection objEntities = map.getNamespace().getObjEntities();
        return objEntities.toArray();
    }

    public void objEntityChanged(EntityEvent e) {
    }

    public void objEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objRelationshipChanged(RelationshipEvent e) {
        this.table.select(e.getRelationship());
    }

    public void objRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getRelationship());
        model.removeRow(e.getRelationship());
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() != this) {
            return;
        }
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        if (entity == e.getEntity() || entity == null) {
            return;
        }
        TableColumn col = this.table.getColumnModel().getColumn(1);
        DefaultCellEditor editor = (DefaultCellEditor)col.getCellEditor();
        JComboBox combo = (JComboBox)editor.getComponent();
        combo.setRenderer(CellRenderers.entityListRendererWithIcons((MappingNamespace)entity.getDataMap()));
        combo.setModel(new DefaultComboBoxModel<Object>(this.createObjEntityComboModel()));
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
    }

    protected void rebuildTable(ObjEntity entity) {
        final ObjRelationshipTableModel model = new ObjRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (ObjEntityRelationshipTab.this.table.getSelectedRow() >= 0) {
                    ObjRelationship rel = model.getRelationship(ObjEntityRelationshipTab.this.table.getSelectedRow());
                    if (rel.getTargetEntity() != null && ((ObjEntity)rel.getSourceEntity()).getDbEntity() != null && ((ObjEntity)rel.getTargetEntity()).getDbEntity() != null) {
                        ObjEntityRelationshipTab.this.resolve.setEnabled(true);
                    } else {
                        ObjEntityRelationshipTab.this.resolve.setEnabled(false);
                    }
                }
            }
        });
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn lockColumn = this.table.getColumnModel().getColumn(4);
        lockColumn.setMinWidth(100);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMinWidth(150);
        col = this.table.getColumnModel().getColumn(1);
        col.setMinWidth(150);
        JComboBox targetCombo = CayenneWidgetFactory.createComboBox(this.createObjEntityComboModel(), false);
        targetCombo.setRenderer(CellRenderers.entityListRendererWithIcons((MappingNamespace)entity.getDataMap()));
        targetCombo.setEditable(false);
        targetCombo.setSelectedIndex(-1);
        DefaultCellEditor editor = new DefaultCellEditor(targetCombo);
        editor.setClickCountToStart(1);
        col.setCellEditor(editor);
        col = this.table.getColumnModel().getColumn(2);
        col.setMinWidth(150);
        col = this.table.getColumnModel().getColumn(3);
        col.setMinWidth(60);
        JComboBox deleteRulesCombo = CayenneWidgetFactory.createComboBox(deleteRules, false);
        deleteRulesCombo.setEditable(false);
        deleteRulesCombo.setSelectedIndex(0);
        editor = new DefaultCellEditor(deleteRulesCombo);
        editor.setClickCountToStart(1);
        col.setCellEditor(editor);
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int align = column == 2 ? 0 : 2;
            super.setHorizontalAlignment(align);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)table.getModel();
            ObjRelationship relationship = model.getRelationship(row);
            if (relationship != null && relationship.getSourceEntity() != model.getEntity()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    }

    class EntityRenderer
    extends StringRenderer {
        EntityRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof CayenneMapEntry) {
                Entity entity;
                DataMap dataMap;
                CayenneMapEntry mapObject = (CayenneMapEntry)value;
                String label = mapObject.getName();
                if (mapObject instanceof Entity && (dataMap = (entity = (Entity)mapObject).getDataMap()) != null && dataMap != ObjEntityRelationshipTab.this.mediator.getCurrentDataMap()) {
                    label = label + " (" + dataMap.getName() + ")";
                }
                value = label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

