/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;

public class SQLTemplateScriptsTab
extends JPanel {
    private static final String DEFAULT_LABEL = "Default";
    protected ProjectController mediator;
    protected JList scripts;
    protected TextAdapter script;
    protected ListSelectionListener scriptRefreshHandler;

    public SQLTemplateScriptsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    protected void initView() {
        this.scriptRefreshHandler = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SQLTemplateScriptsTab.this.displayScript();
                }
            }
        };
        this.scripts = new JList();
        this.scripts.setSelectionMode(0);
        this.scripts.setCellRenderer(new DbAdapterListRenderer(DbAdapterInfo.getStandardAdapterLabels()));
        ArrayList<Object> keys = new ArrayList<Object>(DbAdapterInfo.getStandardAdapters().length + 1);
        keys.addAll(Arrays.asList(DbAdapterInfo.getStandardAdapters()));
        Collections.sort(keys);
        keys.add(0, DEFAULT_LABEL);
        this.scripts.setModel(new DefaultComboBoxModel<Object>(keys.toArray()));
        this.script = new TextAdapter(new JTextArea(15, 30)){

            protected void updateModel(String text) {
                SQLTemplateScriptsTab.this.setSQL(text);
            }
        };
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:100dlu, 3dlu, fill:100dlu:grow", "3dlu, fill:p:grow"));
        builder.add((Component)new JScrollPane(this.scripts, 20, 31), cc.xy(1, 2));
        builder.add((Component)new JScrollPane(this.script.getComponent()), cc.xy(3, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof SQLTemplate)) {
            this.setVisible(false);
            return;
        }
        this.scripts.removeListSelectionListener(this.scriptRefreshHandler);
        this.scripts.setSelectedIndex(0);
        this.displayScript();
        this.scripts.addListSelectionListener(this.scriptRefreshHandler);
        this.script.getComponent().setEnabled(true);
        this.setVisible(true);
    }

    String getSQLTemplate(String key) {
        if (key == null) {
            return null;
        }
        SQLTemplate query = this.getQuery();
        if (query == null) {
            return null;
        }
        return key.equals(DEFAULT_LABEL) ? query.getDefaultTemplate() : query.getCustomTemplate(key);
    }

    SQLTemplate getQuery() {
        Query query = this.mediator.getCurrentQuery();
        return query instanceof SQLTemplate ? (SQLTemplate)query : null;
    }

    void displayScript() {
        SQLTemplate query = this.getQuery();
        if (query == null) {
            this.disableEditor();
            return;
        }
        String key = (String)this.scripts.getSelectedValue();
        if (key == null) {
            this.disableEditor();
            return;
        }
        this.enableEditor();
        String text = key.equals(DEFAULT_LABEL) ? query.getDefaultTemplate() : query.getCustomTemplate(key);
        this.script.setText(text);
    }

    void disableEditor() {
        this.script.setText(null);
        this.script.getComponent().setEnabled(false);
        this.script.getComponent().setEditable(false);
        this.script.getComponent().setBackground(this.getBackground());
    }

    void enableEditor() {
        this.script.getComponent().setEnabled(true);
        this.script.getComponent().setEditable(true);
        this.script.getComponent().setBackground(Color.WHITE);
    }

    void setSQL(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.setSQL(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    void setSQL(String text) {
        SQLTemplate query = this.getQuery();
        if (query == null) {
            return;
        }
        String key = (String)this.scripts.getSelectedValue();
        if (key == null) {
            return;
        }
        if (text != null && (text = text.trim()).length() == 0) {
            text = null;
        }
        if (key.equals(DEFAULT_LABEL)) {
            if (!Util.nullSafeEquals((Object)text, (Object)query.getDefaultTemplate())) {
                query.setDefaultTemplate(text);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)query));
            }
        } else if (!Util.nullSafeEquals((Object)text, (Object)query.getTemplate(key))) {
            query.setTemplate(key, text);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)query));
        }
    }

    final class DbAdapterListRenderer
    extends DefaultListCellRenderer {
        Map adapterLabels;

        DbAdapterListRenderer(Map adapterLabels) {
            this.adapterLabels = adapterLabels != null ? adapterLabels : Collections.EMPTY_MAP;
        }

        public Component getListCellRendererComponent(JList list, Object object, int index, boolean selected, boolean hasFocus) {
            Object label;
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            if ((label = this.adapterLabels.get(object)) == null) {
                label = object;
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, label, index, selected, hasFocus);
            this.setForeground(selected || SQLTemplateScriptsTab.this.getSQLTemplate(object.toString()) != null ? Color.BLACK : Color.LIGHT_GRAY);
            return c;
        }
    }
}

