/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.validation.ValidationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SelectPropertiesPanel
extends JPanel {
    private static Log logObj = LogFactory.getLog(SelectPropertiesPanel.class);
    private static final Integer ZERO = new Integer(0);
    private static final String NO_CACHE_LABEL = "No Result Caching";
    private static final String LOCAL_CACHE_LABEL = "Local Cache (per ObjectContext)";
    private static final String SHARED_CACHE_LABEL = "Shared Cache";
    private static final Object[] CACHE_POLICIES = new Object[]{QueryCacheStrategy.NO_CACHE, QueryCacheStrategy.LOCAL_CACHE, QueryCacheStrategy.SHARED_CACHE};
    private static final Map<QueryCacheStrategy, String> cachePolicyLabels = new TreeMap<QueryCacheStrategy, String>();
    protected TextAdapter fetchLimit;
    protected TextAdapter pageSize;
    protected JComboBox cacheStrategy;
    protected JCheckBox refreshesResults;
    protected ProjectController mediator;

    public SelectPropertiesPanel(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.fetchLimit = new TextAdapter(new JTextField(7)){

            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setFetchLimit(text);
            }
        };
        this.pageSize = new TextAdapter(new JTextField(7)){

            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setPageSize(text);
            }
        };
        this.cacheStrategy = CayenneWidgetFactory.createComboBox();
        this.cacheStrategy.setRenderer(new CacheStrategyRenderer());
        this.refreshesResults = new JCheckBox();
    }

    protected void initController() {
        this.cacheStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object strategy = SelectPropertiesPanel.this.cacheStrategy.getModel().getSelectedItem();
                SelectPropertiesPanel.this.setQueryProperty("cacheStrategy", strategy);
            }
        });
        this.refreshesResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Boolean b = SelectPropertiesPanel.this.refreshesResults.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                SelectPropertiesPanel.this.setQueryProperty("refreshingObjects", b);
            }
        });
    }

    public void initFromModel(Query query) {
        EntityResolver resolver = this.mediator.getCurrentDataDomain().getEntityResolver();
        DefaultComboBoxModel<Object> cacheModel = new DefaultComboBoxModel<Object>(CACHE_POLICIES);
        QueryCacheStrategy selectedStrategy = query.getMetaData(resolver).getCacheStrategy();
        cacheModel.setSelectedItem(selectedStrategy != null ? selectedStrategy : QueryCacheStrategy.getDefaultStrategy());
        this.cacheStrategy.setModel(cacheModel);
        this.fetchLimit.setText(String.valueOf(query.getMetaData(resolver).getFetchLimit()));
        this.pageSize.setText(String.valueOf(query.getMetaData(resolver).getPageSize()));
        this.refreshesResults.setSelected(query.getMetaData(resolver).isRefreshingObjects());
    }

    void setFetchLimit(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.setQueryProperty("fetchLimit", ZERO);
        } else {
            try {
                this.setQueryProperty("fetchLimit", new Integer(string));
            }
            catch (NumberFormatException nfex) {
                throw new ValidationException("Fetch limit must be an integer: " + string);
            }
        }
    }

    void setPageSize(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.setQueryProperty("pageSize", ZERO);
        } else {
            try {
                this.setQueryProperty("pageSize", new Integer(string));
            }
            catch (NumberFormatException nfex) {
                throw new ValidationException("Page size must be an integer: " + string);
            }
        }
    }

    Query getQuery() {
        return this.mediator.getCurrentQuery();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        Container mainPanel = (Container)this.getComponent(0);
        Component[] children = mainPanel.getComponents();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(flag);
        }
    }

    void setQueryProperty(String property, Object value) {
        Query query = this.getQuery();
        if (query != null) {
            try {
                PropertyUtils.setProperty((Object)query, (String)property, (Object)value);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
            }
            catch (Exception ex) {
                logObj.warn((Object)("Error setting property: " + property), (Throwable)ex);
            }
        }
    }

    static {
        cachePolicyLabels.put(QueryCacheStrategy.NO_CACHE, NO_CACHE_LABEL);
        cachePolicyLabels.put(QueryCacheStrategy.LOCAL_CACHE, LOCAL_CACHE_LABEL);
        cachePolicyLabels.put(QueryCacheStrategy.SHARED_CACHE, SHARED_CACHE_LABEL);
    }

    final class CacheStrategyRenderer
    extends DefaultListCellRenderer {
        CacheStrategyRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            if (object != null) {
                object = cachePolicyLabels.get(object);
            }
            if (object == null) {
                object = SelectPropertiesPanel.NO_CACHE_LABEL;
            }
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

