/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAttributeTableModel
extends CayenneTableModel {
    private static final int DB_ATTRIBUTE_NAME = 0;
    private static final int DB_ATTRIBUTE_TYPE = 1;
    private static final int DB_ATTRIBUTE_PRIMARY_KEY = 2;
    private static final int DB_ATTRIBUTE_MANDATORY = 3;
    private static final int DB_ATTRIBUTE_MAX = 4;
    private static final int DB_ATTRIBUTE_SCALE = 5;
    protected DbEntity entity;

    public DbAttributeTableModel(DbEntity entity, ProjectController mediator, Object eventSource) {
        this(entity, mediator, eventSource, new ArrayList<DbAttribute>(entity.getAttributes()));
        this.entity = entity;
    }

    public DbAttributeTableModel(DbEntity entity, ProjectController mediator, Object eventSource, List<DbAttribute> objectList) {
        super(mediator, eventSource, objectList);
    }

    public int nameColumnInd() {
        return 0;
    }

    public int typeColumnInd() {
        return 1;
    }

    public int mandatoryColumnInd() {
        return 3;
    }

    @Override
    public Class<?> getElementsClass() {
        return DbAttribute.class;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    public DbAttribute getAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (DbAttribute)this.objectList.get(row) : null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "PK";
            }
            case 5: {
                return "Scale";
            }
            case 3: {
                return "Mandatory";
            }
            case 4: {
                return "Max Length";
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        DbAttribute attr = this.getAttribute(row);
        if (attr == null) {
            return "";
        }
        switch (column) {
            case 0: {
                return this.getAttributeName(attr);
            }
            case 1: {
                return this.getAttributeType(attr);
            }
            case 2: {
                return this.isPrimaryKey(attr);
            }
            case 5: {
                return this.getScale(attr);
            }
            case 3: {
                return this.isMandatory(attr);
            }
            case 4: {
                return this.getMaxLength(attr);
            }
        }
        return "";
    }

    @Override
    public void setUpdatedValueAt(Object newVal, int row, int col) {
        DbAttribute attr = this.getAttribute(row);
        if (attr == null) {
            return;
        }
        AttributeEvent e = new AttributeEvent(this.eventSource, (Attribute)attr, (Entity)this.entity);
        switch (col) {
            case 0: {
                e.setOldName(attr.getName());
                attr.setName((String)newVal);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                this.setAttributeType((String)newVal, attr);
                break;
            }
            case 2: {
                if (this.setPrimaryKey((Boolean)newVal, attr, row)) break;
                return;
            }
            case 5: {
                this.setScale((String)newVal, attr);
                break;
            }
            case 3: {
                this.setMandatory((Boolean)newVal, attr);
                break;
            }
            case 4: {
                this.setMaxLength((String)newVal, attr);
            }
        }
        this.mediator.fireDbAttributeEvent(e);
    }

    public String getMaxLength(DbAttribute attr) {
        return attr.getMaxLength() >= 0 ? String.valueOf(attr.getMaxLength()) : "";
    }

    public String getAttributeName(DbAttribute attr) {
        return attr.getName();
    }

    public String getAttributeType(DbAttribute attr) {
        return TypesMapping.getSqlNameByType((int)attr.getType());
    }

    public String getScale(DbAttribute attr) {
        return attr.getScale() >= 0 ? String.valueOf(attr.getScale()) : "";
    }

    public Boolean isPrimaryKey(DbAttribute attr) {
        return attr.isPrimaryKey() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isMandatory(DbAttribute attr) {
        return attr.isMandatory() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setMaxLength(String newVal, DbAttribute attr) {
        if (newVal == null || newVal.trim().length() <= 0) {
            attr.setMaxLength(-1);
        } else {
            try {
                attr.setMaxLength(Integer.parseInt(newVal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Invalid Max Length (" + newVal + "), only numbers are allowed", "Invalid Maximum Length", 0);
                return;
            }
        }
    }

    public void setAttributeName(String newVal, DbAttribute attr) {
        String newName = newVal.trim();
        ProjectUtil.setAttributeName((Attribute)attr, newName);
    }

    public void setAttributeType(String newVal, DbAttribute attr) {
        attr.setType(TypesMapping.getSqlTypeByName((String)newVal));
    }

    public void setScale(String newVal, DbAttribute attr) {
        if (newVal == null || newVal.trim().length() <= 0) {
            attr.setScale(-1);
        } else {
            try {
                attr.setScale(Integer.parseInt(newVal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Invalid precision (" + newVal + "), only numbers are allowed.", "Invalid Precision Value", 0);
            }
        }
    }

    public boolean setPrimaryKey(Boolean newVal, DbAttribute attr, int row) {
        boolean flag = newVal;
        if (!flag) {
            attr.setGenerated(false);
            Collection<DbRelationship> relationships = ProjectUtil.getRelationshipsUsingAttributeAsTarget(attr);
            relationships.addAll(ProjectUtil.getRelationshipsUsingAttributeAsSource(attr));
            if (relationships.size() > 0) {
                Iterator<DbRelationship> it = relationships.iterator();
                while (it.hasNext()) {
                    DbRelationship relationship = it.next();
                    if (relationship.isToDependentPK()) continue;
                    it.remove();
                }
                if (relationships.size() > 0) {
                    String message = relationships.size() == 1 ? "Fix \"To Dep PK\" relationship using this attribute?" : "Fix " + relationships.size() + " \"To Dep PK\" relationships using this attribute?";
                    int answer = JOptionPane.showConfirmDialog(Application.getFrame(), message);
                    if (answer != 0) {
                        return false;
                    }
                    for (DbRelationship relationship : relationships) {
                        relationship.setToDependentPK(false);
                    }
                }
            }
        }
        attr.setPrimaryKey(flag);
        if (flag) {
            attr.setMandatory(true);
            this.fireTableCellUpdated(row, 3);
        }
        return true;
    }

    public void setMandatory(Boolean newVal, DbAttribute attr) {
        attr.setMandatory(newVal.booleanValue());
    }

    public void setGenerated(Boolean newVal, DbAttribute attr) {
        attr.setGenerated(newVal.booleanValue());
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        DbAttribute attrib = this.getAttribute(row);
        if (null == attrib) {
            return false;
        }
        return col != this.mandatoryColumnInd() || !attrib.isPrimaryKey();
    }
}

