/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.dbentity.DbAttributeTableModel;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;

public class DbEntityAttributeTab
extends JPanel
implements DbEntityDisplayListener,
ListSelectionListener,
DbAttributeListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;

    public DbEntityAttributeTab(ProjectController temp_mediator) {
        this.mediator = temp_mediator;
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addDbAttributeListener(this);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateObjEntityAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(DbEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveAttributeAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    public void valueChanged(ListSelectionEvent e) {
        this.processExistingSelection(e);
    }

    public void selectAttribute(DbAttribute attr) {
        if (attr == null) {
            Application.getInstance().getAction(RemoveAttributeAction.getActionName()).setEnabled(false);
            return;
        }
        Application.getInstance().getAction(RemoveAttributeAction.getActionName()).setEnabled(true);
        DbAttributeTableModel model = (DbAttributeTableModel)this.table.getModel();
        List attrs = model.getObjectList();
        int attrPos = attrs.indexOf(attr);
        if (attrPos >= 0) {
            this.table.select(attrPos);
        }
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        DbAttribute att = null;
        if (this.table.getSelectedRow() >= 0) {
            DbAttributeTableModel model = (DbAttributeTableModel)this.table.getModel();
            att = model.getAttribute(this.table.getSelectedRow());
            UIUtil.scrollToSelectedRow(this.table);
        }
        this.mediator.fireDbAttributeDisplayEvent(new AttributeDisplayEvent((Object)this, (Attribute)att, (Entity)this.mediator.getCurrentDbEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain()));
    }

    public void dbAttributeChanged(AttributeEvent e) {
        this.table.select(e.getAttribute());
    }

    public void dbAttributeAdded(AttributeEvent e) {
        this.rebuildTable((DbEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    public void dbAttributeRemoved(AttributeEvent e) {
        DbAttributeTableModel model = (DbAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getAttribute());
        model.removeRow(e.getAttribute());
        this.table.select(ind);
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity != null && e.isEntityChanged()) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(DbEntity ent) {
        DbAttributeTableModel model = new DbAttributeTableModel(ent, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(model.nameColumnInd());
        col.setMinWidth(150);
        col = this.table.getColumnModel().getColumn(model.typeColumnInd());
        col.setMinWidth(90);
        Object[] types = TypesMapping.getDatabaseTypes();
        JComboBox comboBox = CayenneWidgetFactory.createComboBox(types, true);
        col.setCellEditor(new DefaultCellEditor(comboBox));
        this.table.getSelectionModel().addListSelectionListener(this);
    }
}

