/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.swing.BoundComponent;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CayenneController
implements BoundComponent {
    private static Log logObj = LogFactory.getLog(CayenneController.class);
    protected CayenneController parent;
    protected Application application;
    protected PropertyChangeSupport propertyChangeSupport;

    public CayenneController(CayenneController parent) {
        this.application = parent != null ? parent.getApplication() : null;
        this.parent = parent;
    }

    public CayenneController(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public CayenneController getParent() {
        return this.parent;
    }

    public abstract Component getView();

    public FSPath getLastDirectory() {
        FSPath path = (FSPath)this.getViewDomain().getDetail("lastDir", FSPath.class, true);
        if (path.getPath() == null) {
            String pathString = this.getParent() != null ? this.getParent().getLastDirectory().getPath() : System.getProperty("user.home");
            path.setPath(pathString);
        }
        return path;
    }

    protected Domain getViewDomain() {
        return this.getApplication().getPreferenceDomain().getSubdomain(this.getView().getClass());
    }

    protected void reportError(String title, Throwable th) {
        th = Util.unwindException((Throwable)th);
        logObj.info((Object)("Error in " + this.getClass().getName()), th);
        JOptionPane.showMessageDialog(this.getView(), th.getMessage(), title, 0);
    }

    protected void centerView() {
        Window parentWindow = this.parent.getWindow();
        Dimension parentSize = parentWindow.getSize();
        Dimension windowSize = this.getView().getSize();
        Point parentLocation = new Point(0, 0);
        if (parentWindow.isShowing()) {
            parentLocation = parentWindow.getLocationOnScreen();
        }
        int x = parentLocation.x + parentSize.width / 2 - windowSize.width / 2;
        int y = parentLocation.y + parentSize.height / 2 - windowSize.height / 2;
        this.getView().setLocation(x, y);
    }

    protected void makeCloseableOnEscape() {
        Window window = this.getWindow();
        if (!(window instanceof JDialog)) {
            return;
        }
        final JDialog dialog = (JDialog)window;
        KeyStroke escReleased = KeyStroke.getKeyStroke(27, 0, true);
        ActionListener closeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dialog.isVisible()) {
                    switch (dialog.getDefaultCloseOperation()) {
                        case 1: {
                            dialog.setVisible(false);
                            break;
                        }
                        case 2: {
                            dialog.setVisible(false);
                            dialog.dispose();
                            break;
                        }
                    }
                }
            }
        };
        dialog.getRootPane().registerKeyboardAction(closeAction, escReleased, 2);
    }

    public Window getWindow() {
        for (Component view = this.getView(); view != null; view = view.getParent()) {
            if (!(view instanceof Window)) continue;
            return (Window)view;
        }
        return null;
    }

    public JFrame getFrame() {
        for (Component view = this.getView(); view != null; view = view.getParent()) {
            if (!(view instanceof JFrame)) continue;
            return (JFrame)view;
        }
        return null;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(String expression, PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(expression, listener);
    }

    public void bindingUpdated(String expression, Object newValue) {
    }
}

