/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class CayenneWidgetFactory {
    protected CayenneWidgetFactory() {
    }

    public static JComboBox createComboBox(Collection model, boolean sort) {
        return CayenneWidgetFactory.createComboBox(model.toArray(), sort);
    }

    public static JComboBox createComboBox(Object[] model, boolean sort) {
        JComboBox comboBox = CayenneWidgetFactory.createComboBox();
        if (sort) {
            Arrays.sort(model);
        }
        comboBox.setModel(new DefaultComboBoxModel<Object>(model));
        return comboBox;
    }

    public static JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox();
        CayenneWidgetFactory.initFormWidget(comboBox);
        comboBox.setBackground(Color.WHITE);
        return comboBox;
    }

    public static JTextField createTextField() {
        return CayenneWidgetFactory.createTextField(20);
    }

    public static JTextField createTextField(int columns) {
        JTextField textField = new JTextField(columns);
        CayenneWidgetFactory.initFormWidget(textField);
        CayenneWidgetFactory.initTextField(textField);
        return textField;
    }

    protected static void initTextField(final JTextField textField) {
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textField.transferFocus();
            }
        });
    }

    protected static void initFormWidget(JComponent component) {
        component.setFont(component.getFont().deriveFont(0, 12.0f));
    }

    public static JButton createLabelButton(String text) {
        JButton but = CayenneWidgetFactory.createButton(text);
        but.setBorderPainted(false);
        but.setHorizontalAlignment(2);
        but.setFocusPainted(false);
        but.setMargin(new Insets(0, 0, 0, 0));
        but.setBorder(null);
        return but;
    }

    public static JButton createButton(String text) {
        return new JButton(text);
    }
}

