/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.EJBQLJoinAppender;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBQLIdentifierColumnsTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private Set<String> columns;

    EJBQLIdentifierColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        Map<String, String> xfields = null;
        if (this.context.isAppendingResultColumns()) {
            xfields = this.context.nextEntityResult().getDbFields(this.context.getEntityResolver());
        }
        final Map<String, String> fields = xfields;
        final String idVar = expression.getText();
        ClassDescriptor descriptor = this.context.getEntityDescriptor(idVar);
        PropertyVisitor visitor = new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                EJBQLJoinAppender joinAppender = null;
                String marker = null;
                EJBQLTableId lhsId = new EJBQLTableId(idVar);
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                    }
                    if (pathPart instanceof DbRelationship) {
                        if (marker == null) {
                            marker = EJBQLJoinAppender.makeJoinTailMarker(idVar);
                            joinAppender = EJBQLIdentifierColumnsTranslator.this.context.getTranslatorFactory().getJoinAppender(EJBQLIdentifierColumnsTranslator.this.context);
                        }
                        DbRelationship dr = (DbRelationship)pathPart;
                        EJBQLTableId rhsId = new EJBQLTableId(lhsId, dr.getName());
                        joinAppender.appendOuterJoin(marker, lhsId, rhsId);
                        lhsId = rhsId;
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, oa, (DbAttribute)pathPart, fields, oa.getType());
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                for (DbJoin join : dbRel.getJoins()) {
                    DbAttribute src = join.getSource();
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, null, src, fields);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        DbEntity table = descriptor.getEntity().getDbEntity();
        for (DbAttribute pk : table.getPrimaryKeys()) {
            this.appendColumn(idVar, null, pk, fields);
        }
        Iterator<DbAttribute> discriminatorColumns = descriptor.getDiscriminatorColumns();
        while (discriminatorColumns.hasNext()) {
            this.appendColumn(idVar, null, discriminatorColumns.next(), fields);
        }
        return false;
    }

    private void appendColumn(String identifier, ObjAttribute property, DbAttribute column, Map<String, String> fields) {
        this.appendColumn(identifier, property, column, fields, null);
    }

    private void appendColumn(String identifier, ObjAttribute property, DbAttribute column, Map<String, String> fields, String javaType) {
        DbEntity table = (DbEntity)column.getEntity();
        String alias = this.context.getTableAlias(identifier, table.getFullyQualifiedName());
        String columnName = alias + "." + column.getName();
        Set<String> columns = this.getColumns();
        if (columns.add(columnName)) {
            this.context.append(columns.size() > 1 ? ", " : " ");
            if (this.context.isAppendingResultColumns()) {
                this.context.append("#result('");
            }
            this.context.append(columnName);
            if (this.context.isAppendingResultColumns()) {
                if (javaType == null) {
                    javaType = TypesMapping.getJavaBySqlType(column.getType());
                }
                String columnLabel = fields.get(property != null ? property.getDbAttributePath() : column.getName());
                this.context.append("' '").append(javaType).append("' '").append(columnLabel).append("' '").append(columnLabel).append("' " + column.getType()).append(")");
            }
        }
    }

    private Set<String> getColumns() {
        if (this.columns == null) {
            this.columns = new HashSet<String>();
        }
        return this.columns;
    }
}

