/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.UpdateQuery;

public class UpdateTranslator
extends QueryAssembler {
    public void dbRelationshipAdded(DbRelationship relationship, JoinType joinType, String joinSplitAlias) {
        throw new UnsupportedOperationException("db relationships not supported");
    }

    public DbEntity getRootDbEntity() {
        return this.query.getMetaData(this.entityResolver).getDbEntity();
    }

    public ObjEntity getRootEntity() {
        return this.query.getMetaData(this.entityResolver).getObjEntity();
    }

    public String getCurrentAlias() {
        throw new UnsupportedOperationException("aliases not supported");
    }

    public void resetJoinStack() {
    }

    public String createSqlString() throws Exception {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("UPDATE ");
        DbEntity dbEnt = this.getRootEntity().getDbEntity();
        queryBuf.append(dbEnt.getFullyQualifiedName());
        this.buildSetClause(queryBuf, (UpdateQuery)this.query);
        StringBuilder qualifier = new StringBuilder();
        this.adapter.getQualifierTranslator(this).appendPart(qualifier);
        if (qualifier.length() > 0) {
            queryBuf.append(" WHERE ").append((CharSequence)qualifier);
        }
        return queryBuf.toString();
    }

    private void buildSetClause(StringBuffer queryBuf, UpdateQuery query) {
        Map<String, Object> updAttrs = query.getUpdAttributes();
        Iterator<Map.Entry<String, Object>> attrIt = updAttrs.entrySet().iterator();
        if (!attrIt.hasNext()) {
            throw new CayenneRuntimeException("Nothing to update.");
        }
        DbEntity dbEnt = this.getRootEntity().getDbEntity();
        queryBuf.append(" SET ");
        boolean appendedSomething = false;
        while (attrIt.hasNext()) {
            Map.Entry<String, Object> entry = attrIt.next();
            String nextKey = entry.getKey();
            Object attrVal = entry.getValue();
            if (appendedSomething) {
                queryBuf.append(", ");
            }
            queryBuf.append(nextKey).append(" = ?");
            super.addToParamList((DbAttribute)dbEnt.getAttribute(nextKey), attrVal);
            appendedSomething = true;
        }
    }
}

