/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.cayenne.jpa.map.JpaEntityListener;
import org.apache.cayenne.jpa.map.JpaLifecycleCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListenerAnnotationLoader {
    public JpaEntityListener getEntityListener(Class<?> listenerClass) {
        JpaEntityListener listener = new JpaEntityListener();
        boolean hasAnnotations = false;
        Method[] methods = listenerClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isValidListenerMethod(methods[i]) || !this.processAnnotations(methods[i], listener)) continue;
            hasAnnotations = true;
        }
        if (hasAnnotations) {
            listener.setClassName(listenerClass.getName());
            return listener;
        }
        return null;
    }

    protected boolean isValidListenerMethod(Method m) {
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            return false;
        }
        if (!Void.TYPE.equals(m.getReturnType())) {
            return false;
        }
        Class<?>[] params = m.getParameterTypes();
        return params.length == 1 && Object.class.equals(params[0]);
    }

    protected boolean processAnnotations(Method method, JpaEntityListener listener) {
        boolean hasListenerAnnotations = false;
        if (method.isAnnotationPresent(PrePersist.class)) {
            listener.setPrePersist(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PostPersist.class)) {
            listener.setPostPersist(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PreRemove.class)) {
            listener.setPreRemove(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PostRemove.class)) {
            listener.setPostRemove(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PreUpdate.class)) {
            listener.setPreUpdate(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PostUpdate.class)) {
            listener.setPostUpdate(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        if (method.isAnnotationPresent(PostLoad.class)) {
            listener.setPostLoad(new JpaLifecycleCallback(method.getName()));
            hasListenerAnnotations = true;
        }
        return hasListenerAnnotations;
    }
}

