/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.conf.AnnotationProcessor;
import org.apache.cayenne.jpa.conf.AnnotationProcessorFactory;
import org.apache.cayenne.jpa.conf.AnnotationProcessorStack;
import org.apache.cayenne.jpa.conf.ClassAnnotationProcessorFactory;
import org.apache.cayenne.jpa.conf.EntityCallbackAnnotationProcessorFactory;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.conf.MemberAnnotationProcessorFactory;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaAbstractEntity;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.map.JpaManagedClass;
import org.apache.cayenne.jpa.map.JpaPropertyDescriptor;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.SimpleValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMapAnnotationLoader {
    static final Map<String, Integer> TYPE_ANNOTATION_ORDERING_WEIGHTS = new HashMap<String, Integer>();
    static final Map<String, Integer> MEMBER_ANNOTATION_ORDERING_WEIGHTS;
    protected EntityMapLoaderContext context;
    protected Comparator<Annotation> typeAnnotationsSorter;
    protected Comparator<Annotation> memberAnnotationsSorter;
    protected AnnotationProcessorFactory classProcessorFactory;
    protected AnnotationProcessorFactory memberProcessorFactory;
    protected AnnotationProcessorFactory callbackProcessorFactory;

    public EntityMapAnnotationLoader(EntityMapLoaderContext context) {
        this.context = context;
        this.typeAnnotationsSorter = new AnnotationSorter(TYPE_ANNOTATION_ORDERING_WEIGHTS);
        this.memberAnnotationsSorter = new AnnotationSorter(MEMBER_ANNOTATION_ORDERING_WEIGHTS);
        this.classProcessorFactory = new ClassAnnotationProcessorFactory();
        this.memberProcessorFactory = new MemberAnnotationProcessorFactory();
        this.callbackProcessorFactory = new EntityCallbackAnnotationProcessorFactory();
    }

    public void loadClassMapping(Class<?> managedClass) throws JpaProviderException {
        if (this.context.getEntityMap().getManagedClass(managedClass.getName()) != null) {
            this.context.recordConflict(new SimpleValidationFailure(managedClass.getName(), "Duplicate managed class declaration " + managedClass.getName()));
            return;
        }
        Annotation[] classAnnotations = managedClass.getAnnotations();
        Arrays.sort(classAnnotations, this.typeAnnotationsSorter);
        JpaClassDescriptor descriptor = new JpaClassDescriptor(managedClass);
        descriptor.setAccess(this.context.getEntityMap().getAccess());
        AnnotationContext stack = new AnnotationContext(descriptor);
        stack.push(this.context.getEntityMap());
        for (int i = 0; i < classAnnotations.length; ++i) {
            AnnotationProcessor processor = this.classProcessorFactory.getProcessor(classAnnotations[i]);
            if (processor == null) continue;
            processor.onStartElement(managedClass, stack);
        }
        if (stack.depth() == 1) {
            return;
        }
        if (stack.peek() instanceof JpaAbstractEntity) {
            for (Method callback : this.getEntityCallbacks(managedClass)) {
                this.applyEntityCallbackAnnotations(callback, stack);
            }
        }
        boolean fieldAccess = false;
        for (JpaPropertyDescriptor property : descriptor.getFieldDescriptors()) {
            stack.setPropertyDescriptor(property);
            if (!this.applyMemberAnnotations(property, stack)) continue;
            fieldAccess = true;
        }
        boolean propertyAccess = false;
        for (JpaPropertyDescriptor property : descriptor.getPropertyDescriptors()) {
            stack.setPropertyDescriptor(property);
            if (!this.applyMemberAnnotations(property, stack)) continue;
            propertyAccess = true;
        }
        if (stack.peek() instanceof JpaManagedClass) {
            JpaManagedClass entity = (JpaManagedClass)stack.peek();
            if (fieldAccess && propertyAccess) {
                throw new JpaProviderException("Entity '" + entity.getClassName() + "' has both property and field annotations.");
            }
            if (fieldAccess) {
                descriptor.setAccess(AccessType.FIELD);
                entity.setAccess(AccessType.FIELD);
            } else if (propertyAccess) {
                descriptor.setAccess(AccessType.PROPERTY);
                entity.setAccess(AccessType.PROPERTY);
            }
        }
        for (int i = classAnnotations.length - 1; i >= 0; --i) {
            AnnotationProcessor processor = this.classProcessorFactory.getProcessor(classAnnotations[i]);
            if (processor == null) continue;
            processor.onFinishElement(managedClass, stack);
        }
    }

    protected boolean applyMemberAnnotations(JpaPropertyDescriptor property, AnnotationProcessorStack stack) {
        AnnotationProcessor memberProcessor;
        int j;
        AnnotatedElement member = property.getMember();
        Annotation[] annotations = member.getAnnotations();
        Arrays.sort(annotations, this.memberAnnotationsSorter);
        for (j = 0; j < annotations.length; ++j) {
            memberProcessor = this.memberProcessorFactory.getProcessor(annotations[j]);
            if (memberProcessor == null) continue;
            memberProcessor.onStartElement(member, stack);
        }
        for (j = annotations.length - 1; j >= 0; --j) {
            memberProcessor = this.memberProcessorFactory.getProcessor(annotations[j]);
            if (memberProcessor == null) continue;
            memberProcessor.onFinishElement(member, stack);
        }
        return annotations.length > 0;
    }

    protected void applyEntityCallbackAnnotations(Method method, AnnotationProcessorStack stack) {
        Annotation[] annotations = method.getAnnotations();
        for (int j = 0; j < annotations.length; ++j) {
            AnnotationProcessor callbackProcessor = this.callbackProcessorFactory.getProcessor(annotations[j]);
            if (callbackProcessor == null) continue;
            callbackProcessor.onStartElement(method, stack);
        }
    }

    protected Collection<Method> getEntityCallbacks(Class<?> managedClass) {
        ArrayList<Method> callbacks = new ArrayList<Method>(3);
        Method[] methods = managedClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            int modifiers = methods[i].getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !Void.TYPE.equals(methods[i].getReturnType()) || (params = methods[i].getParameterTypes()).length != 0) continue;
            callbacks.add(methods[i]);
        }
        return callbacks;
    }

    static {
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(Entity.class.getName(), 1);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(Embeddable.class.getName(), 1);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(MappedSuperclass.class.getName(), 1);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(SequenceGenerator.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(NamedNativeQueries.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(NamedNativeQuery.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(NamedQueries.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(NamedQuery.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(SqlResultSetMapping.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(TableGenerator.class.getName(), 2);
        TYPE_ANNOTATION_ORDERING_WEIGHTS.put(EntityListeners.class.getName(), 2);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS = new HashMap<String, Integer>();
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Id.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Basic.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(EmbeddedId.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Version.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(ManyToOne.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(OneToMany.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(OneToOne.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(ManyToMany.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Embedded.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Transient.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(AssociationOverride.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(AssociationOverrides.class.getName(), 1);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(AttributeOverride.class.getName(), 2);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(AttributeOverrides.class.getName(), 2);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(GeneratedValue.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Temporal.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(TableGenerator.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(SequenceGenerator.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Lob.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Temporal.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Enumerated.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(MapKey.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(OrderBy.class.getName(), 3);
        MEMBER_ANNOTATION_ORDERING_WEIGHTS.put(Column.class.getName(), 3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AnnotationContext
    implements AnnotationProcessorStack {
        LinkedList<Object> stack = new LinkedList();
        JpaClassDescriptor classDescriptor;
        JpaPropertyDescriptor propertyDescriptor;

        AnnotationContext(JpaClassDescriptor classDescriptor) {
            this.classDescriptor = classDescriptor;
        }

        void setPropertyDescriptor(JpaPropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        public int depth() {
            return this.stack.size();
        }

        @Override
        public Object peek() {
            return this.stack.peek();
        }

        @Override
        public Object pop() {
            return this.stack.removeFirst();
        }

        @Override
        public void push(Object object) {
            if (object instanceof JpaAttribute) {
                JpaAttribute attribute = (JpaAttribute)object;
                attribute.setName(this.propertyDescriptor.getName());
                attribute.setPropertyDescriptor(this.propertyDescriptor);
            } else if (object instanceof JpaManagedClass) {
                ((JpaManagedClass)object).setClassDescriptor(this.classDescriptor);
            }
            this.stack.addFirst(object);
        }

        @Override
        public void recordConflict(AnnotatedElement element, Class<?> annotatedType, String message) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Problem processing annotation: ").append(annotatedType.getName());
            buffer.append(", annotated element: ").append(element);
            if (message != null) {
                buffer.append(", details: ").append(message);
            }
            EntityMapAnnotationLoader.this.context.recordConflict(new SimpleValidationFailure(this.peek(), buffer.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AnnotationSorter
    implements Comparator<Annotation> {
        private Map<String, Integer> weights;

        AnnotationSorter(Map<String, Integer> weights) {
            this.weights = weights;
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            Integer w1 = this.weights.get(o1.annotationType().getName());
            Integer w2 = this.weights.get(o2.annotationType().getName());
            return Util.nullSafeCompare(false, w1, w2);
        }
    }
}

