/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class EntityMapLoaderContext {
    protected ValidationResult conflicts;
    protected JpaEntityMap entityMap;
    protected PersistenceUnitInfo unit;
    protected ClassLoader tempClassLoader;

    public EntityMapLoaderContext(PersistenceUnitInfo unit) {
        this.unit = unit;
        this.conflicts = new ValidationResult();
        this.entityMap = new JpaEntityMap();
        this.tempClassLoader = unit.getNewTempClassLoader();
    }

    public PersistenceUnitInfo getUnit() {
        return this.unit;
    }

    public JpaEntityMap getEntityMap() {
        return this.entityMap;
    }

    public void recordConflict(ValidationFailure conflict) {
        this.conflicts.addFailure(conflict);
    }

    public ValidationResult getConflicts() {
        return this.conflicts;
    }

    public ClassLoader getTempClassLoader() {
        return this.tempClassLoader;
    }
}

