/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.TemporalType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;

public class JpaVersion
extends JpaAttribute {
    protected JpaColumn column;
    protected TemporalType temporal;

    @TreeNodeChild
    public JpaColumn getColumn() {
        return this.column;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<version");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        encoder.println('>');
        encoder.indent(1);
        if (this.column != null) {
            this.column.encodeAsXML(encoder);
        }
        if (this.temporal != null) {
            encoder.println("<temporal>" + this.temporal.name() + "</temporal>");
        }
        encoder.indent(-1);
        encoder.println("</version>");
    }

    public int getDefaultJdbcType() {
        if (this.getTemporal() != null) {
            if (TemporalType.TIMESTAMP == this.getTemporal()) {
                return 93;
            }
            if (TemporalType.DATE == this.getTemporal()) {
                return 91;
            }
            return 92;
        }
        return TypesMapping.getSqlTypeByJava(this.getPropertyDescriptor().getType());
    }

    public void setColumn(JpaColumn column) {
        this.column = column;
    }

    public TemporalType getTemporal() {
        return this.temporal;
    }

    public void setTemporal(TemporalType temporal) {
        this.temporal = temporal;
    }
}

