/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.NodeDataSource;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeLoadDelegate
implements ConfigLoaderDelegate {
    private static final Log logger = LogFactory.getLog(RuntimeLoadDelegate.class);
    static final String _1_2_PACKAGE_PREFIX = "org.objectstyle.cayenne.";
    static final String _2_0_PACKAGE_PREFIX = "org.apache.cayenne.";
    protected Map<String, DataDomain> domains = new HashMap<String, DataDomain>();
    protected Map<String, String> views = new HashMap<String, String>();
    protected ConfigStatus status;
    protected Configuration config;
    protected long startTime;
    protected MapLoader mapLoader;

    public RuntimeLoadDelegate(Configuration config, ConfigStatus status) {
        this.config = config;
        if (status == null) {
            status = new ConfigStatus();
        }
        this.status = status;
    }

    protected DataDomain findDomain(String name) throws FindException {
        DataDomain domain = this.domains.get(name);
        if (domain == null) {
            throw new FindException("Can't find DataDomain: " + name);
        }
        return domain;
    }

    protected DataMap findMap(String domainName, String mapName) throws FindException {
        DataDomain domain = this.findDomain(domainName);
        DataMap map = domain.getMap(mapName);
        if (map == null) {
            throw new FindException("Can't find DataMap: " + mapName);
        }
        return map;
    }

    protected DataNode findNode(String domainName, String nodeName) throws FindException {
        DataDomain domain = this.findDomain(domainName);
        DataNode node = domain.getNode(nodeName);
        if (node == null) {
            throw new FindException("Can't find DataNode: " + nodeName);
        }
        return node;
    }

    @Override
    public boolean loadError(Throwable th) {
        logger.info("Parser Exception.", th);
        this.status.getOtherFailures().add(th.getMessage());
        return false;
    }

    @Override
    public void shouldLoadProjectVersion(String version) {
        this.config.setProjectVersion(version);
    }

    @Override
    public void shouldRegisterDataView(String name, String location) {
        this.views.put(name, location);
    }

    @Override
    public void shouldLoadDataDomainProperties(String domainName, Map properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        DataDomain domain = null;
        try {
            domain = this.findDomain(domainName);
        }
        catch (FindException ex) {
            logger.info("Error: Domain is not loaded: " + domainName);
            throw new ConfigurationException("Domain is not loaded: " + domainName);
        }
        domain.initWithProperties(properties);
    }

    @Override
    public void shouldLoadDataDomain(String domainName) {
        if (domainName == null) {
            logger.info("Error: unnamed <domain>.");
            throw new ConfigurationException("Domain 'name' attribute must be not null.");
        }
        logger.info("loaded domain: " + domainName);
        this.domains.put(domainName, new DataDomain(domainName));
    }

    @Override
    public void shouldLoadDataMaps(String domainName, Map<String, DataMap> locations) {
        if (locations.size() == 0) {
            return;
        }
        DataDomain domain = null;
        try {
            domain = this.findDomain(domainName);
        }
        catch (FindException ex) {
            logger.info("Error: Domain is not loaded: " + domainName);
            throw new ConfigurationException("Domain is not loaded: " + domainName);
        }
        for (String name : locations.keySet()) {
            DataMap map = domain.getMap(name);
            if (map != null) continue;
            this.loadDataMap(domain, name, locations);
        }
    }

    protected MapLoader getMapLoader() {
        if (this.mapLoader == null) {
            this.mapLoader = new MapLoader();
        }
        return this.mapLoader;
    }

    protected DataMap loadDataMap(DataDomain domain, String mapName, Map locations) {
        if (mapName == null) {
            throw new ConfigurationException("Error: <map> without 'name'.");
        }
        String location = (String)locations.get(mapName);
        if (location == null) {
            throw new ConfigurationException("Error: map '" + mapName + "' without 'location'.");
        }
        InputStream mapIn = this.config.getMapConfiguration(location);
        if (mapIn == null) {
            logger.info("Warning: map location not found.");
            this.getStatus().addFailedMap(mapName, location, "map location not found");
            return null;
        }
        try {
            DataMap map = this.getMapLoader().loadDataMap(new InputSource(mapIn));
            logger.info("loaded <map name='" + mapName + "' location='" + location + "'>.");
            map.setName(mapName);
            map.setLocation(location);
            domain.addMap(map);
            return map;
        }
        catch (Exception dmex) {
            logger.info("Warning: map loading failed.", dmex);
            this.getStatus().addFailedMap(mapName, location, "map loading failed - " + dmex.getMessage());
            return null;
        }
    }

    protected DataNode createDataNode(String nodeName) {
        return new DataNode(nodeName);
    }

    @Override
    public void shouldLoadDataNode(String domainName, String nodeName, String dataSource, String adapter, String factory) {
        logger.info("loading <node name='" + nodeName + "' datasource='" + dataSource + "' factory='" + factory + "'>.");
        if (nodeName == null) {
            throw new ConfigurationException("Error: <node> without 'name'.");
        }
        factory = this.convertClassNameFromV1_2(factory);
        adapter = this.convertClassNameFromV1_2(adapter);
        if (dataSource == null) {
            logger.info("Warning: <node> '" + nodeName + "' has no 'datasource'.");
        }
        if (factory == null) {
            if (this.config.getDataSourceFactory(null) != null) {
                logger.info("Warning: <node> '" + nodeName + "' without 'factory'.");
            } else {
                throw new ConfigurationException("Error: <node> '" + nodeName + "' without 'factory'.");
            }
        }
        DataNode node = this.createDataNode(nodeName);
        node.setDataSourceFactory(factory);
        node.setDataSourceLocation(dataSource);
        try {
            DataSourceFactory confFactory = this.config.getDataSourceFactory(factory);
            DataSourceFactory localFactory = confFactory != null ? confFactory : (DataSourceFactory)Class.forName(factory).newInstance();
            logger.info("using factory: " + localFactory.getClass().getName());
            localFactory.initializeWithParentConfiguration(this.config);
            DataSource ds = localFactory.getDataSource(dataSource);
            if (ds != null) {
                logger.info("loaded datasource.");
                node.setDataSource(ds);
            } else {
                logger.info("Warning: null datasource.");
                this.getStatus().getFailedDataSources().put(nodeName, dataSource);
            }
        }
        catch (Exception ex) {
            logger.info("Error: DataSource load failed", ex);
            this.getStatus().addFailedDataSource(nodeName, dataSource, "DataSource load failed - " + ex.getMessage());
        }
        this.initAdapter(node, adapter);
        try {
            this.findDomain(domainName).addNode(node);
        }
        catch (FindException ex) {
            logger.info("Error: can't load node, unknown domain: " + domainName);
            this.getStatus().addFailedDataSource(nodeName, nodeName, "can't load node, unknown domain: " + domainName);
        }
    }

    String convertClassNameFromV1_2(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(_1_2_PACKAGE_PREFIX)) {
            return _2_0_PACKAGE_PREFIX + name.substring(_1_2_PACKAGE_PREFIX.length());
        }
        return name;
    }

    protected void initAdapter(DataNode node, String adapterName) {
        if (adapterName != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> dbAdapterClass = Class.forName(adapterName, true, cl);
                node.setAdapter((DbAdapter)dbAdapterClass.newInstance());
                return;
            }
            catch (Exception ex) {
                logger.info("instantiating adapter failed", ex);
                this.getStatus().addFailedAdapter(node.getName(), adapterName, "instantiating adapter failed - " + ex.getMessage());
            }
        }
        logger.info("no adapter set, using automatic adapter.");
        node.setAdapter(new AutoAdapter(new NodeDataSource(node)));
    }

    @Override
    public void shouldLinkDataMap(String domainName, String nodeName, String mapName) {
        if (mapName == null) {
            logger.info("<map-ref> has no 'name'.");
            throw new ConfigurationException("<map-ref> has no 'name'.");
        }
        logger.info("loaded map-ref: " + mapName + ".");
        DataMap map = null;
        DataNode node = null;
        try {
            map = this.findMap(domainName, mapName);
        }
        catch (FindException ex) {
            logger.info("Error: unknown map: " + mapName);
            this.getStatus().addFailedMapRefs(mapName, "unknown map: " + mapName);
            return;
        }
        try {
            node = this.findNode(domainName, nodeName);
        }
        catch (FindException ex) {
            logger.info("Error: unknown node: " + nodeName);
            this.getStatus().addFailedMapRefs(mapName, "unknown node: " + nodeName);
            return;
        }
        node.addDataMap(map);
    }

    public Map<String, DataDomain> getDomains() {
        return this.domains;
    }

    @Override
    public ConfigStatus getStatus() {
        return this.status;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    public void finishedLoading() {
        if (this.status.hasFailures() && !this.config.isIgnoringLoadFailures()) {
            StringBuilder msg = new StringBuilder(128);
            msg.append("Load failures. Main configuration class: ");
            msg.append(this.config.getClass().getName());
            msg.append(", details: ");
            msg.append(this.status.describeFailures());
            throw new ConfigurationException(msg.toString());
        }
        for (DataDomain domain : this.getDomains().values()) {
            domain.getEntityResolver().applyDBLayerDefaults();
            domain.getEntityResolver().applyObjectLayerDefaults();
            this.config.addDomain(domain);
        }
        this.config.setDataViewLocations(this.views);
        logger.info("finished configuration loading in " + (System.currentTimeMillis() - this.startTime) + " ms.");
    }

    @Override
    public void startedLoading() {
        this.startTime = System.currentTimeMillis();
        logger.info("started configuration loading.");
    }

    class FindException
    extends Exception {
        public FindException(String msg) {
            super(msg);
        }
    }
}

