/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.ConfigSaverDelegate;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeSaveDelegate
implements ConfigSaverDelegate {
    protected Configuration config;

    public RuntimeSaveDelegate(Configuration config) {
        this.config = config;
    }

    public RuntimeSaveDelegate() {
    }

    protected DataDomain findDomain(String domainName) {
        DataDomain domain = this.config.getDomain(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Can't find DataDomain: " + domainName);
        }
        return domain;
    }

    protected DataNode findNode(String domainName, String nodeName) {
        DataDomain domain = this.findDomain(domainName);
        DataNode node = domain.getNode(nodeName);
        if (node == null) {
            throw new IllegalArgumentException("Can't find DataNode: " + domainName + "." + nodeName);
        }
        return node;
    }

    @Override
    public String projectVersion() {
        return this.config.getProjectVersion();
    }

    @Override
    public Iterator domainNames() {
        Transformer tr = new Transformer(){

            public Object transform(Object input) {
                return ((DataDomain)input).getName();
            }
        };
        return new TransformIterator(this.config.getDomains().iterator(), tr);
    }

    @Override
    public Iterator<String> viewNames() {
        return this.config.getDataViewLocations().keySet().iterator();
    }

    @Override
    public String viewLocation(String dataViewName) {
        return this.config.getDataViewLocations().get(dataViewName);
    }

    @Override
    public Iterator propertyNames(String domainName) {
        return this.findDomain(domainName).getProperties().keySet().iterator();
    }

    @Override
    public String propertyValue(String domainName, String propertyName) {
        return (String)this.findDomain(domainName).getProperties().get(propertyName);
    }

    @Override
    public String mapLocation(String domainName, String mapName) {
        return this.findDomain(domainName).getMap(mapName).getLocation();
    }

    @Override
    public Iterator mapNames(String domainName) {
        ArrayList<DataMap> maps = new ArrayList<DataMap>(this.findDomain(domainName).getDataMaps());
        Collections.sort(maps, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = o1 != null ? ((DataMap)o1).getName() : null;
                String name2 = o1 != null ? ((DataMap)o2).getName() : null;
                return Util.nullSafeCompare(true, name1, name2);
            }
        });
        Transformer tr = new Transformer(){

            public Object transform(Object input) {
                return ((DataMap)input).getName();
            }
        };
        return new TransformIterator(maps.iterator(), tr);
    }

    @Override
    public String nodeAdapterName(String domainName, String nodeName) {
        DbAdapter adapter = this.findNode(domainName, nodeName).getAdapter();
        return adapter != null && adapter.getClass() != AutoAdapter.class ? adapter.getClass().getName() : null;
    }

    @Override
    public String nodeDataSourceName(String domainName, String nodeName) {
        return this.findNode(domainName, nodeName).getDataSourceLocation();
    }

    @Override
    public String nodeFactoryName(String domainName, String nodeName) {
        return this.findNode(domainName, nodeName).getDataSourceFactory();
    }

    @Override
    public Iterator nodeNames(String domainName) {
        Transformer tr = new Transformer(){

            public Object transform(Object input) {
                return ((DataNode)input).getName();
            }
        };
        ArrayList<DataNode> nodes = new ArrayList<DataNode>(this.findDomain(domainName).getDataNodes());
        Collections.sort(nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = o1 != null ? ((DataNode)o1).getName() : null;
                String name2 = o1 != null ? ((DataNode)o2).getName() : null;
                return Util.nullSafeCompare(true, name1, name2);
            }
        });
        return new TransformIterator(nodes.iterator(), tr);
    }

    @Override
    public Iterator linkedMapNames(String domainName, String nodeName) {
        Transformer tr = new Transformer(){

            public Object transform(Object input) {
                return ((DataMap)input).getName();
            }
        };
        Collection<DataMap> maps = this.findNode(domainName, nodeName).getDataMaps();
        return new TransformIterator(maps.iterator(), tr);
    }
}

