/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.modeler.dialog.pref.DataSourceCreator;
import org.apache.cayenne.modeler.dialog.pref.DataSourceDuplicator;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public class DataSourcePreferences
extends CayenneController {
    protected DataSourcePreferencesView view = new DataSourcePreferencesView(this);
    protected PreferenceEditor editor;
    protected String dataSourceKey;
    protected Map dataSources;

    public DataSourcePreferences(PreferenceDialog parentController) {
        super(parentController);
        this.editor = parentController.getEditor();
        this.dataSources = this.getDataSourceDomain().getDetailsMap(DBConnectionInfo.class);
        Object[] keys = this.dataSources.keySet().toArray();
        Arrays.sort(keys);
        DefaultComboBoxModel<Object> dataSourceModel = new DefaultComboBoxModel<Object>(keys);
        this.view.getDataSources().setModel(dataSourceModel);
        this.initBindings();
        if (keys.length > 0) {
            this.view.getDataSources().setSelectedIndex(0);
            this.editDataSourceAction();
        }
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getAddDataSource(), "newDataSourceAction()");
        builder.bindToAction(this.view.getDuplicateDataSource(), "duplicateDataSourceAction()");
        builder.bindToAction(this.view.getRemoveDataSource(), "removeDataSourceAction()");
        builder.bindToAction(this.view.getTestDataSource(), "testDataSourceAction()");
        builder.bindToComboSelection(this.view.getDataSources(), "dataSourceKey");
    }

    public Domain getDataSourceDomain() {
        return this.editor.editableInstance(this.getApplication().getPreferenceDomain());
    }

    public PreferenceEditor getEditor() {
        return this.editor;
    }

    public Map getDataSources() {
        return this.dataSources;
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public void setDataSourceKey(String dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
        this.editDataSourceAction();
    }

    public DBConnectionInfo getConnectionInfo() {
        return (DBConnectionInfo)this.dataSources.get(this.dataSourceKey);
    }

    public void newDataSourceAction() {
        DataSourceCreator creatorWizard = new DataSourceCreator(this);
        DBConnectionInfo dataSource = creatorWizard.startupAction();
        if (dataSource != null) {
            this.dataSources.put(creatorWizard.getName(), dataSource);
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.view.getDataSources().setSelectedItem(creatorWizard.getName());
            this.editDataSourceAction();
        }
    }

    public void duplicateDataSourceAction() {
        DataSourceDuplicator wizard;
        DBConnectionInfo dataSource;
        Object selected = this.view.getDataSources().getSelectedItem();
        if (selected != null && (dataSource = (wizard = new DataSourceDuplicator(this, selected.toString())).startupAction()) != null) {
            this.dataSources.put(wizard.getName(), dataSource);
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.view.getDataSources().setSelectedItem(wizard.getName());
            this.editDataSourceAction();
        }
    }

    public void removeDataSourceAction() {
        String key = this.getDataSourceKey();
        if (key != null) {
            this.editor.deleteDetail(this.getDataSourceDomain(), key);
            this.dataSources.remove(key);
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.editDataSourceAction(keys.length > 0 ? keys[0] : null);
        }
    }

    public void editDataSourceAction(Object dataSourceKey) {
        this.view.getDataSources().setSelectedItem(dataSourceKey);
        this.editDataSourceAction();
    }

    public void editDataSourceAction() {
        this.view.getDataSourceEditor().setConnectionInfo(this.getConnectionInfo());
    }

    public void testDataSourceAction() {
        DBConnectionInfo currentDataSource = this.getConnectionInfo();
        if (currentDataSource == null) {
            return;
        }
        if (currentDataSource.getJdbcDriver() == null) {
            JOptionPane.showMessageDialog(null, "No JDBC Driver specified", "Warning", 2);
            return;
        }
        if (currentDataSource.getUrl() == null) {
            JOptionPane.showMessageDialog(null, "No Database URL specified", "Warning", 2);
            return;
        }
        try {
            Class driverClass = this.getApplication().getClassLoadingService().loadClass(currentDataSource.getJdbcDriver());
            Driver driver = (Driver)driverClass.newInstance();
            Connection c = new DriverDataSource(driver, currentDataSource.getUrl(), currentDataSource.getUserName(), currentDataSource.getPassword()).getConnection();
            try {
                c.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "Connected Successfully", "Success", 1);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            JOptionPane.showMessageDialog(null, "Error connecting to DB: " + th.getLocalizedMessage(), "Warning", 2);
            return;
        }
    }
}

