/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.query;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.scopemvc.core.Selector;

public class QueryTypeModel {
    public static final Selector OBJECT_SELECT_QUERY_SELECTOR = Selector.fromString("objectSelectQuery");
    public static final Selector RAW_SQL_QUERY_SELECTOR = Selector.fromString("rawSQLQuery");
    public static final Selector PROCEDURE_QUERY_SELECTOR = Selector.fromString("procedureQuery");
    protected AbstractQuery objectSelectQuery = new SelectQuery();
    protected AbstractQuery rawSQLQuery;
    protected AbstractQuery procedureQuery = new ProcedureQuery();
    protected AbstractQuery selectedQuery;

    public QueryTypeModel(DataMap root) {
        SQLTemplate rawSQLQuery = new SQLTemplate();
        rawSQLQuery.setRoot(root);
        rawSQLQuery.setFetchingDataRows(true);
        this.rawSQLQuery = rawSQLQuery;
        this.selectedQuery = this.objectSelectQuery;
    }

    public AbstractQuery getSelectedQuery() {
        return this.selectedQuery;
    }

    public void setSelectedQuery(AbstractQuery selectedQuery) {
        this.selectedQuery = selectedQuery;
    }

    public boolean isObjectSelectQuery() {
        return this.selectedQuery == this.objectSelectQuery;
    }

    public void setObjectSelectQuery(boolean flag) {
        if (!flag && this.isObjectSelectQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isObjectSelectQuery()) {
            this.selectedQuery = this.objectSelectQuery;
        }
    }

    public boolean isRawSQLQuery() {
        return this.selectedQuery == this.rawSQLQuery;
    }

    public void setRawSQLQuery(boolean flag) {
        if (!flag && this.isRawSQLQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isRawSQLQuery()) {
            this.selectedQuery = this.rawSQLQuery;
        }
    }

    public boolean isProcedureQuery() {
        return this.selectedQuery == this.procedureQuery;
    }

    public void setProcedureQuery(boolean flag) {
        if (!flag && this.isProcedureQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isProcedureQuery()) {
            this.selectedQuery = this.procedureQuery;
        }
    }
}

