/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DataDomainView
extends JPanel
implements DomainDisplayListener {
    protected ProjectController projectController;
    protected TextAdapter name;
    protected TextAdapter cacheSize;
    protected JCheckBox objectValidation;
    protected JCheckBox externalTransactions;
    protected TextAdapter dataContextFactory;
    protected JCheckBox sharedCache;
    protected JCheckBox remoteUpdates;
    protected JButton configRemoteUpdates;

    public DataDomainView(ProjectController projectController) {
        this.projectController = projectController;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataDomainView.this.setDomainName(text);
            }
        };
        this.cacheSize = new TextAdapter(new JTextField(10)){

            protected void updateModel(String text) {
                DataDomainView.this.setCacheSize(text);
            }
        };
        this.dataContextFactory = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.dataContextFactory", text, null);
            }
        };
        this.objectValidation = new JCheckBox();
        this.externalTransactions = new JCheckBox();
        this.sharedCache = new JCheckBox();
        this.remoteUpdates = new JCheckBox();
        this.configRemoteUpdates = new JButton("Configure...");
        this.configRemoteUpdates.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:50dlu, 3dlu, fill:47dlu, 3dlu, fill:100", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("DataDomain Configuration", cc.xywh(1, 1, 7, 1));
        builder.addLabel("DataDomain Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xywh(3, 3, 5, 1));
        builder.addLabel("DataContext Factory:", cc.xy(1, 5));
        builder.add((Component)this.dataContextFactory.getComponent(), cc.xywh(3, 5, 5, 1));
        builder.addLabel("Object Validation:", cc.xy(1, 7));
        builder.add((Component)this.objectValidation, cc.xy(3, 7));
        builder.addLabel("Container-Managed Transactions:", cc.xy(1, 9));
        builder.add((Component)this.externalTransactions, cc.xy(3, 9));
        builder.addSeparator("Cache Configuration", cc.xywh(1, 11, 7, 1));
        builder.addLabel("Max. Number of Objects:", cc.xy(1, 13));
        builder.add((Component)this.cacheSize.getComponent(), cc.xy(3, 13));
        builder.addLabel("Use Shared Cache:", cc.xy(1, 15));
        builder.add((Component)this.sharedCache, cc.xy(3, 15));
        builder.addLabel("Remote Change Notifications:", cc.xy(1, 17));
        builder.add((Component)this.remoteUpdates, cc.xy(3, 17));
        builder.add((Component)this.configRemoteUpdates, cc.xy(7, 17));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void initController() {
        this.projectController.addDomainDisplayListener(this);
        this.objectValidation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.objectValidation.isSelected() ? "true" : "false";
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.validatingObjectsOnCommit", value, Boolean.toString(true));
            }
        });
        this.externalTransactions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.externalTransactions.isSelected() ? "true" : "false";
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.usingExternalTransactions", value, Boolean.toString(false));
            }
        });
        this.sharedCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.sharedCache.isSelected() ? "true" : "false";
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.sharedCache", value, Boolean.toString(true));
                DataDomainView.this.remoteUpdates.setEnabled(DataDomainView.this.sharedCache.isSelected());
                if (!DataDomainView.this.sharedCache.isSelected()) {
                    DataDomainView.this.remoteUpdates.setSelected(false);
                    DataDomainView.this.setDomainProperty("cayenne.DataRowStore.remote.notify", "false", Boolean.toString(false));
                }
                DataDomainView.this.configRemoteUpdates.setEnabled(DataDomainView.this.remoteUpdates.isSelected());
            }
        });
        this.remoteUpdates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.remoteUpdates.isSelected() ? "true" : "false";
                DataDomainView.this.configRemoteUpdates.setEnabled(DataDomainView.this.remoteUpdates.isSelected());
                DataDomainView.this.setDomainProperty("cayenne.DataRowStore.remote.notify", value, Boolean.toString(false));
            }
        });
        this.configRemoteUpdates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CacheSyncConfigController(DataDomainView.this.projectController).startup();
            }
        });
    }

    protected void setDomainProperty(String property, String value, String defaultValue) {
        Map properties;
        Object oldValue;
        DataDomain domain = this.projectController.getCurrentDataDomain();
        if (domain == null) {
            return;
        }
        if ("".equals(value)) {
            value = null;
        }
        if (value != null && value.equals(defaultValue)) {
            value = null;
        }
        if (!Util.nullSafeEquals(value, oldValue = (properties = domain.getProperties()).get(property))) {
            properties.put(property, value);
            DomainEvent e = new DomainEvent((Object)this, domain);
            this.projectController.fireDomainEvent(e);
        }
    }

    public String getDomainProperty(String property, String defaultValue) {
        DataDomain domain = this.projectController.getCurrentDataDomain();
        if (domain == null) {
            return null;
        }
        String value = (String)domain.getProperties().get(property);
        return value != null ? value : defaultValue;
    }

    public boolean getDomainBooleanProperty(String property, String defaultValue) {
        return "true".equalsIgnoreCase(this.getDomainProperty(property, defaultValue));
    }

    public void currentDomainChanged(DomainDisplayEvent e) {
        DataDomain domain = e.getDomain();
        if (null == domain) {
            return;
        }
        this.name.setText(domain.getName());
        this.cacheSize.setText(this.getDomainProperty("cayenne.DataRowStore.snapshot.size", Integer.toString(10000)));
        this.objectValidation.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.validatingObjectsOnCommit", Boolean.toString(true)));
        this.externalTransactions.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.usingExternalTransactions", Boolean.toString(false)));
        this.dataContextFactory.setText(this.getDomainProperty("cayenne.DataDomain.dataContextFactory", null));
        this.sharedCache.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.sharedCache", Boolean.toString(true)));
        this.remoteUpdates.setSelected(this.getDomainBooleanProperty("cayenne.DataRowStore.remote.notify", Boolean.toString(false)));
        this.remoteUpdates.setEnabled(this.sharedCache.isSelected());
        this.configRemoteUpdates.setEnabled(this.remoteUpdates.isEnabled() && this.remoteUpdates.isSelected());
    }

    void setDomainName(String newName) {
        if (newName == null || newName.trim().length() == 0) {
            throw new ValidationException("Enter name for DataDomain");
        }
        Configuration configuration = ((ApplicationProject)Application.getProject()).getConfiguration();
        DataDomain domain = this.projectController.getCurrentDataDomain();
        DataDomain matchingDomain = configuration.getDomain(newName);
        if (matchingDomain == null) {
            Domain prefs = this.projectController.getPreferenceDomainForDataDomain();
            DomainEvent e = new DomainEvent((Object)this, domain, domain.getName());
            ProjectUtil.setDataDomainName(configuration, domain, newName);
            prefs.rename(newName);
            this.projectController.fireDomainEvent(e);
        } else if (matchingDomain != domain) {
            throw new ValidationException("There is another DataDomain named '" + newName + "'. Use a different name.");
        }
    }

    void setCacheSize(String text) {
        if (text.length() > 0) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                throw new ValidationException("Cache size must be an integer: " + text);
            }
        }
        this.setDomainProperty("cayenne.DataRowStore.snapshot.size", text, Integer.toString(10000));
    }
}

