/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.RawQueryPropertiesPanel;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class ProcedureQueryView
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected JComboBox queryRoot;
    protected SelectPropertiesPanel properties;

    public ProcedureQueryView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ProcedureQueryView.this.setQueryName(text);
            }
        };
        this.queryRoot = CayenneWidgetFactory.createComboBox();
        this.queryRoot.setRenderer(CellRenderers.listRendererWithIcons());
        this.properties = new RawQueryPropertiesPanel(this.mediator){

            protected void setEntity(ObjEntity entity) {
                ProcedureQueryView.this.setEntity(entity);
            }

            public ObjEntity getEntity(Query query) {
                if (query instanceof ProcedureQuery) {
                    return ProcedureQueryView.this.getEntity((ProcedureQuery)query);
                }
                return null;
            }
        };
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("ProcedureQuery Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Procedure:", cc.xy(1, 5));
        builder.add((Component)this.queryRoot, cc.xy(3, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    private void initController() {
        this.queryRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AbstractQuery query = (AbstractQuery)ProcedureQueryView.this.mediator.getCurrentQuery();
                if (query != null) {
                    query.setRoot(ProcedureQueryView.this.queryRoot.getModel().getSelectedItem());
                    ProcedureQueryView.this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
                }
            }
        });
        this.mediator.addQueryDisplayListener(new QueryDisplayListener(){

            public void currentQueryChanged(QueryDisplayEvent e) {
                ProcedureQueryView.this.initFromModel();
            }
        });
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof ProcedureQuery)) {
            this.setVisible(false);
            return;
        }
        ProcedureQuery procedureQuery = (ProcedureQuery)query;
        this.properties.setEnabled(true);
        this.name.setText(procedureQuery.getName());
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] roots = map.getProcedures().toArray();
        if (roots.length > 1) {
            Arrays.sort(roots, Comparators.getDataMapChildrenComparator());
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(roots);
        model.setSelectedItem(procedureQuery.getRoot());
        this.queryRoot.setModel(model);
        this.properties.initFromModel(procedureQuery);
        this.setVisible(true);
    }

    void setQueryName(String newName) {
        AbstractQuery query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = (AbstractQuery)this.mediator.getCurrentQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.");
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQuery(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.");
        }
        QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName(), map);
        ProjectUtil.setQueryName(map, query, newName);
        this.mediator.fireQueryEvent(e);
    }

    ObjEntity getEntity(ProcedureQuery query) {
        String entityName = query.getResultEntityName();
        if (entityName == null) {
            return null;
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            return null;
        }
        return map.getObjEntity(entityName);
    }

    void setEntity(ObjEntity entity) {
        Query query = this.mediator.getCurrentQuery();
        if (query instanceof ProcedureQuery) {
            ProcedureQuery procedureQuery = (ProcedureQuery)query;
            procedureQuery.setResultEntityName(entity != null ? entity.getName() : null);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, procedureQuery));
        }
    }
}

