/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.PLSQLTokenMarker;
import org.syntax.jedit.tokenmarker.SQLTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class SQLTemplateScriptsTab
extends JPanel
implements DocumentListener {
    private static final String DEFAULT_LABEL = "Default";
    private static final TokenMarker SQL_TEMPLATE_MARKER;
    protected ProjectController mediator;
    protected JList scripts;
    protected JEditTextArea scriptArea;
    private boolean updateDisabled;
    protected ListSelectionListener scriptRefreshHandler;

    public SQLTemplateScriptsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    protected void initView() {
        this.scriptRefreshHandler = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SQLTemplateScriptsTab.this.displayScript();
                }
            }
        };
        this.scripts = new JList();
        this.scripts.setSelectionMode(0);
        this.scripts.setCellRenderer(new DbAdapterListRenderer(DbAdapterInfo.getStandardAdapterLabels()));
        ArrayList<Object> keys = new ArrayList<Object>(DbAdapterInfo.getStandardAdapters().length + 1);
        keys.addAll(Arrays.asList(DbAdapterInfo.getStandardAdapters()));
        Collections.sort(keys);
        keys.add(0, DEFAULT_LABEL);
        this.scripts.setModel(new DefaultComboBoxModel<Object>(keys.toArray()));
        this.scriptArea = new JEditTextArea();
        this.scriptArea.setTokenMarker(SQL_TEMPLATE_MARKER);
        this.scriptArea.getDocument().addDocumentListener(this);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:100dlu, 3dlu, fill:100dlu:grow", "3dlu, fill:p:grow"));
        builder.add((Component)new JScrollPane(this.scripts, 20, 31), cc.xy(1, 2));
        builder.add((Component)new JScrollPane(this.scriptArea), cc.xy(3, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof SQLTemplate)) {
            this.setVisible(false);
            return;
        }
        this.scripts.removeListSelectionListener(this.scriptRefreshHandler);
        this.scripts.setSelectedIndex(0);
        this.displayScript();
        this.scripts.addListSelectionListener(this.scriptRefreshHandler);
        this.scriptArea.setEnabled(true);
        this.setVisible(true);
    }

    String getSQLTemplate(String key) {
        if (key == null) {
            return null;
        }
        SQLTemplate query = this.getQuery();
        if (query == null) {
            return null;
        }
        return key.equals(DEFAULT_LABEL) ? query.getDefaultTemplate() : query.getCustomTemplate(key);
    }

    SQLTemplate getQuery() {
        Query query = this.mediator.getCurrentQuery();
        return query instanceof SQLTemplate ? (SQLTemplate)query : null;
    }

    void displayScript() {
        SQLTemplate query = this.getQuery();
        if (query == null) {
            this.disableEditor();
            return;
        }
        String key = (String)this.scripts.getSelectedValue();
        if (key == null) {
            this.disableEditor();
            return;
        }
        this.enableEditor();
        String text = key.equals(DEFAULT_LABEL) ? query.getDefaultTemplate() : query.getCustomTemplate(key);
        this.updateDisabled = true;
        this.scriptArea.setText(text);
        this.updateDisabled = false;
    }

    void disableEditor() {
        this.scriptArea.setText(null);
        this.scriptArea.setEnabled(false);
        this.scriptArea.setEditable(false);
        this.scriptArea.setBackground(this.getBackground());
    }

    void enableEditor() {
        this.scriptArea.setEnabled(true);
        this.scriptArea.setEditable(true);
        this.scriptArea.setBackground(Color.WHITE);
    }

    void setSQL(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.setSQL(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    void setSQL(String text) {
        SQLTemplate query = this.getQuery();
        if (query == null) {
            return;
        }
        String key = (String)this.scripts.getSelectedValue();
        if (key == null) {
            return;
        }
        if (text != null && (text = text.trim()).length() == 0) {
            text = null;
        }
        if (key.equals(DEFAULT_LABEL)) {
            if (!Util.nullSafeEquals(text, query.getDefaultTemplate())) {
                query.setDefaultTemplate(text);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
            }
        } else if (!Util.nullSafeEquals(text, query.getTemplate(key))) {
            query.setTemplate(key, text);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.updateDisabled) {
            this.setSQL(e);
        }
    }

    static {
        KeywordMap map = PLSQLTokenMarker.getKeywordMap();
        map.add("FIRST", (byte)6);
        map.add("LIMIT", (byte)6);
        map.add("OFFSET", (byte)6);
        map.add("TOP", (byte)6);
        map.add("#bind", (byte)7);
        map.add("#bindEqual", (byte)7);
        map.add("#bindNotEqual", (byte)7);
        map.add("#bindObjectEqual", (byte)7);
        map.add("#bindObjectNotEqual", (byte)7);
        map.add("#chain", (byte)7);
        map.add("#chunk", (byte)7);
        map.add("#end", (byte)7);
        map.add("#result", (byte)7);
        SQL_TEMPLATE_MARKER = new SQLTokenMarker(map);
    }

    final class DbAdapterListRenderer
    extends DefaultListCellRenderer {
        Map adapterLabels;

        DbAdapterListRenderer(Map adapterLabels) {
            this.adapterLabels = adapterLabels != null ? adapterLabels : Collections.EMPTY_MAP;
        }

        public Component getListCellRendererComponent(JList list, Object object, int index, boolean selected, boolean hasFocus) {
            Object label;
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            if ((label = this.adapterLabels.get(object)) == null) {
                label = object;
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, label, index, selected, hasFocus);
            this.setForeground(selected || SQLTemplateScriptsTab.this.getSQLTemplate(object.toString()) != null ? Color.BLACK : Color.LIGHT_GRAY);
            return c;
        }
    }
}

