/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DBCPDataSourceFactory;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conf.JNDIDataSourceFactory;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.editor.datanode.CustomDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.DBCPDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.DataNodeEditor;
import org.apache.cayenne.modeler.editor.datanode.DataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JDBCDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JNDIDataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.MainDataNodeView;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationException;

public class MainDataNodeEditor
extends CayenneController {
    protected static final String NO_LOCAL_DATA_SOURCE = "Select DataSource for Local Work...";
    static final String[] standardDataSourceFactories = new String[]{DriverDataSourceFactory.class.getName(), JNDIDataSourceFactory.class.getName(), DBCPDataSourceFactory.class.getName()};
    protected MainDataNodeView view;
    protected DataNodeEditor tabbedPaneController;
    protected DataNode node;
    protected Map datasourceEditors;
    protected Map localDataSources;
    protected DataSourceEditor defaultSubeditor;
    protected BindingDelegate nodeChangeProcessor;
    protected ObjectBinding[] bindings;
    protected ObjectBinding localDataSourceBinding;

    public MainDataNodeEditor(ProjectController parent, DataNodeEditor tabController) {
        super(parent);
        this.tabbedPaneController = tabController;
        this.view = new MainDataNodeView();
        this.datasourceEditors = new HashMap();
        this.localDataSources = new HashMap();
        this.nodeChangeProcessor = new BindingDelegate(){

            public void modelUpdated(ObjectBinding binding, Object oldValue, Object newValue) {
                DataNodeEvent e = new DataNodeEvent((Object)MainDataNodeEditor.this, MainDataNodeEditor.this.node);
                if (binding != null && binding.getView() == MainDataNodeEditor.this.view.getDataNodeName()) {
                    e.setOldName(oldValue != null ? oldValue.toString() : null);
                }
                ((ProjectController)MainDataNodeEditor.this.getParent()).fireDataNodeEvent(e);
            }
        };
        this.defaultSubeditor = new CustomDataSourceEditor(parent, this.nodeChangeProcessor);
        this.initController();
    }

    public Component getView() {
        return this.view;
    }

    public String getFactoryName() {
        return this.node != null ? this.node.getDataSourceFactory() : null;
    }

    public void setFactoryName(String factoryName) {
        if (this.node != null) {
            this.node.setDataSourceFactory(factoryName);
            this.showDataSourceSubview(factoryName);
        }
    }

    public String getNodeName() {
        return this.node != null ? this.node.getName() : null;
    }

    public void setNodeName(String newName) {
        if (this.node == null) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Empty DataNode Name");
        }
        ProjectController parent = (ProjectController)this.getParent();
        Configuration config = ((ApplicationProject)parent.getProject()).getConfiguration();
        DataNode matchingNode = null;
        for (DataDomain domain : config.getDomains()) {
            DataNode nextNode = domain.getNode(newName);
            if (nextNode == this.node || nextNode == null) continue;
            matchingNode = nextNode;
            break;
        }
        if (matchingNode != null) {
            throw new ValidationException("There is another DataNode named '" + newName + "'. Use a different name.");
        }
        ProjectUtil.setDataNodeName(parent.getCurrentDataDomain(), this.node, newName);
    }

    protected void initController() {
        this.view.getDataSourceDetail().add(this.defaultSubeditor.getView(), "default");
        this.view.getFactories().setEditable(true);
        this.view.getFactories().setModel(new DefaultComboBoxModel<String>(standardDataSourceFactories));
        ((ProjectController)this.getParent()).addDataNodeDisplayListener(new DataNodeDisplayListener(){

            public void currentDataNodeChanged(DataNodeDisplayEvent e) {
                MainDataNodeEditor.this.refreshView(e.getDataNode());
            }
        });
        this.getView().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                MainDataNodeEditor.this.refreshView(MainDataNodeEditor.this.node != null ? MainDataNodeEditor.this.node : ((ProjectController)MainDataNodeEditor.this.getParent()).getCurrentDataNode());
            }
        });
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.localDataSourceBinding = builder.bindToComboSelection(this.view.getLocalDataSources(), "parent.dataNodePreferences.localDataSource", NO_LOCAL_DATA_SOURCE);
        builder.setDelegate(this.nodeChangeProcessor);
        this.bindings = new ObjectBinding[2];
        this.bindings[0] = builder.bindToTextField(this.view.getDataNodeName(), "nodeName");
        this.bindings[1] = builder.bindToComboSelection(this.view.getFactories(), "factoryName");
        builder.bindToAction(this.view.getConfigLocalDataSources(), "dataSourceConfigAction()");
    }

    public void dataSourceConfigAction() {
        PreferenceDialog prefs = new PreferenceDialog(this);
        prefs.showDataSourceEditorAction(this.view.getLocalDataSources().getSelectedItem());
        this.refreshLocalDataSources();
    }

    protected void refreshLocalDataSources() {
        this.localDataSources.clear();
        Collection sources = this.getApplication().getPreferenceDomain().getDetails(DBConnectionInfo.class);
        int len = sources.size();
        Object[] keys = new Object[len + 1];
        keys[0] = NO_LOCAL_DATA_SOURCE;
        Iterator it = sources.iterator();
        for (int i = 1; i <= len; ++i) {
            DBConnectionInfo info = (DBConnectionInfo)it.next();
            keys[i] = info.getKey();
            this.localDataSources.put(keys[i], info);
        }
        this.view.getLocalDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
        this.localDataSourceBinding.updateView();
    }

    protected void refreshView(DataNode node) {
        this.node = node;
        if (node == null) {
            this.getView().setVisible(false);
            return;
        }
        this.refreshLocalDataSources();
        for (int i = 0; i < this.bindings.length; ++i) {
            this.bindings[i].updateView();
        }
        this.showDataSourceSubview(this.getFactoryName());
    }

    protected void showDataSourceSubview(String factoryName) {
        DataSourceEditor c = (DataSourceEditor)this.datasourceEditors.get(factoryName);
        if (c == null) {
            if (DriverDataSourceFactory.class.getName().equals(factoryName)) {
                c = new JDBCDataSourceEditor((ProjectController)this.getParent(), this.nodeChangeProcessor);
            } else if (JNDIDataSourceFactory.class.getName().equals(factoryName)) {
                c = new JNDIDataSourceEditor((ProjectController)this.getParent(), this.nodeChangeProcessor);
            } else if (DBCPDataSourceFactory.class.getName().equals(factoryName)) {
                c = new DBCPDataSourceEditor((ProjectController)this.getParent(), this.nodeChangeProcessor);
            } else {
                this.defaultSubeditor.setNode(this.node);
                this.disabledTab("default");
                this.view.getDataSourceDetailLayout().show(this.view.getDataSourceDetail(), "default");
                return;
            }
            this.datasourceEditors.put(factoryName, c);
            this.view.getDataSourceDetail().add(c.getView(), factoryName);
            this.view.getDataSourceDetail().getParent().validate();
        }
        c.setNode(this.node);
        this.disabledTab(factoryName);
        this.view.getDataSourceDetailLayout().show(this.view.getDataSourceDetail(), factoryName);
    }

    protected void disabledTab(String name) {
        if (name.equals(standardDataSourceFactories[0])) {
            this.tabbedPaneController.getTabComponent().setEnabledAt(2, true);
        } else {
            this.tabbedPaneController.getTabComponent().setEnabledAt(2, false);
        }
    }
}

