/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.dbentity.PKGeneratorPanel;

public class PKDBGeneratorPanel
extends PKGeneratorPanel {
    private JComboBox attributes;

    public PKDBGeneratorPanel(ProjectController mediator) {
        super(mediator);
        this.initView();
    }

    private void initView() {
        this.attributes = new JComboBox();
        this.attributes.setEditable(false);
        this.attributes.setRenderer(new AttributeRenderer());
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("right:70dlu, 3dlu, fill:200dlu", ""));
        builder.setDefaultDialogBorder();
        builder.append("Auto Incremented:", (Component)this.attributes);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    public void setDbEntity(DbEntity entity) {
        if (this.isVisible()) {
            this.updateView(entity);
        }
    }

    public void onInit(DbEntity entity) {
        DbAttribute pk;
        this.resetStrategy(entity, true, false);
        Collection<DbAttribute> pkAttributes = entity.getPrimaryKeys();
        if (pkAttributes.size() == 1 && TypesMapping.isNumeric((pk = pkAttributes.iterator().next()).getType()) && !pk.isGenerated()) {
            pk.setGenerated(true);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, entity));
        }
        this.updateView(entity);
    }

    void updateView(final DbEntity entity) {
        ItemListener[] listeners = this.attributes.getItemListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.attributes.removeItemListener(listeners[i]);
        }
        Collection<DbAttribute> pkAttributes = entity.getPrimaryKeys();
        if (pkAttributes.isEmpty()) {
            this.attributes.removeAllItems();
            this.attributes.addItem("<Entity has no PK columns>");
            this.attributes.setSelectedIndex(0);
            this.attributes.setEnabled(false);
        } else {
            this.attributes.setEnabled(true);
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(pkAttributes.toArray());
            String noSelection = "<Select Generated Column>";
            model.insertElementAt(noSelection, 0);
            model.setSelectedItem(noSelection);
            this.attributes.setModel(model);
            for (DbAttribute a : pkAttributes) {
                if (!a.isGenerated()) continue;
                model.setSelectedItem(a);
                break;
            }
            this.attributes.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Object item = e.getItem();
                    if (item instanceof DbAttribute) {
                        boolean generated = e.getStateChange() == 1;
                        DbAttribute a = (DbAttribute)item;
                        if (a.isGenerated() != generated) {
                            a.setGenerated(generated);
                            PKDBGeneratorPanel.this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, entity));
                        }
                    }
                }
            });
        }
        this.revalidate();
    }

    class AttributeRenderer
    extends BasicComboBoxRenderer {
        AttributeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DbAttribute) {
                DbAttribute a = (DbAttribute)value;
                String type = TypesMapping.getSqlNameByType(a.getType());
                value = a.getName() + " (" + (type != null ? type : "?") + ")";
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

