/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.cayenne.modeler.util.CayenneCellEditor;
import org.apache.cayenne.modeler.util.combo.ComboBoxCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CayenneWidgetFactory {
    protected CayenneWidgetFactory() {
    }

    public static JComboBox createComboBox(Collection<String> model, boolean sort) {
        return CayenneWidgetFactory.createComboBox(model.toArray(), sort);
    }

    public static JComboBox createComboBox(Object[] model, boolean sort) {
        JComboBox comboBox = CayenneWidgetFactory.createComboBox();
        if (sort) {
            Arrays.sort(model);
        }
        comboBox.setModel(new DefaultComboBoxModel<Object>(model));
        return comboBox;
    }

    public static JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox();
        CayenneWidgetFactory.initFormWidget(comboBox);
        comboBox.setBackground(Color.WHITE);
        comboBox.setMaximumRowCount(12);
        return comboBox;
    }

    public static DefaultCellEditor createCellEditor(JTextField textField) {
        return new CayenneCellEditor(textField);
    }

    public static TableCellEditor createCellEditor(JComboBox combo) {
        if (Boolean.TRUE.equals(combo.getClientProperty("JComboBox.autoCompletion"))) {
            return new ComboBoxCellEditor(combo);
        }
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        return editor;
    }

    public static JTextField createTextField() {
        return CayenneWidgetFactory.createTextField(20);
    }

    public static JTextField createTextField(int columns) {
        JTextField textField = new JTextField(columns);
        CayenneWidgetFactory.initFormWidget(textField);
        CayenneWidgetFactory.initTextField(textField);
        return textField;
    }

    protected static void initTextField(final JTextField textField) {
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textField.transferFocus();
            }
        });
    }

    protected static void initFormWidget(JComponent component) {
        component.setFont(component.getFont().deriveFont(0, 12.0f));
    }

    public static JButton createLabelButton(String text) {
        JButton but = CayenneWidgetFactory.createButton(text);
        but.setBorderPainted(false);
        but.setHorizontalAlignment(2);
        but.setFocusPainted(false);
        but.setMargin(new Insets(0, 0, 0, 0));
        but.setBorder(null);
        return but;
    }

    public static JButton createButton(String text) {
        return new JButton(text);
    }
}

