/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Collection;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.EntityMergeListener;

public class DeleteRuleUpdater
implements EntityMergeListener {
    private static DeleteRuleUpdater instance;

    public static void updateDataMap(DataMap map) {
        Collection<ObjEntity> entities = map.getObjEntities();
        for (ObjEntity ent : entities) {
            DeleteRuleUpdater.updateObjEntity(ent);
        }
    }

    public static void updateObjEntity(ObjEntity e) {
        Collection<ObjRelationship> rels = e.getRelationships();
        for (ObjRelationship rel : rels) {
            DeleteRuleUpdater.updateObjRelationship(rel);
        }
    }

    public static void updateObjRelationship(ObjRelationship rel) {
        rel.setDeleteRule(rel.isToMany() ? 3 : 1);
    }

    public void objAttributeAdded(ObjAttribute attr) {
    }

    public void objRelationshipAdded(ObjRelationship rel) {
        DeleteRuleUpdater.updateObjRelationship(rel);
    }

    public static EntityMergeListener getEntityMergeListener() {
        if (instance == null) {
            instance = new DeleteRuleUpdater();
        }
        return instance;
    }
}

