/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.controller.basic;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.controller.basic.ViewContext;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.Controller;
import org.scopemvc.core.PropertyView;
import org.scopemvc.core.View;
import org.scopemvc.util.UIStrings;

public abstract class BasicController
implements Controller {
    public static final String HANDLE_CONTROL_RUNTIME_ERROR_MSG_ID = "_HANDLE_CONTROL_RUNTIME_ERROR_MSG";
    public static final String HIDE_VIEW_CONTROL_ID = "_HIDE_VIEW";
    public static final String CHANGE_MODEL_CONTROL_ID = "_CHANGE_MODEL";
    public static final String EXIT_CONTROL_ID = "_exit";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$controller$basic$BasicController == null ? (class$org$scopemvc$controller$basic$BasicController = BasicController.class$("org.scopemvc.controller.basic.BasicController")) : class$org$scopemvc$controller$basic$BasicController);
    private BasicController parent;
    private LinkedList children = new LinkedList();
    private Object model;
    private View view;
    static /* synthetic */ Class class$org$scopemvc$controller$basic$BasicController;

    public final List getChildren() {
        return this.children;
    }

    public final Controller getParent() {
        return this.parent;
    }

    public final Object getModel() {
        return this.model;
    }

    public final View getView() {
        return this.view;
    }

    public final Controller getTopParent() {
        Controller controller = this;
        while (controller.getParent() != null) {
            controller = controller.getParent();
        }
        return controller;
    }

    public final void setModel(Object object) {
        if (this.model == object) {
            return;
        }
        this.model = object;
        this.bindModelToView(this.view, this.model);
    }

    public final void setView(View view) {
        if (view == this.view) {
            return;
        }
        if (this.view != null) {
            this.hideView();
            this.view.setController(null);
            this.bindModelToView(this.view, null);
        }
        this.view = view;
        if (this.view != null) {
            this.bindModelToView(this.view, this.model);
            this.view.setController(this);
        }
    }

    public final void setModelAndView(Object object, View view) {
        this.setModel(null);
        this.setModel(object);
        this.setView(view);
    }

    public final void addChild(BasicController basicController) {
        if (basicController == null) {
            throw new IllegalArgumentException("Can't add a null child Controller.");
        }
        basicController.setParent(this);
    }

    public final void removeChild(BasicController basicController) {
        if (this.getChildren().contains(basicController)) {
            basicController.setParent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleControl(Control control) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleControl: " + control);
        }
        if (control == null) {
            throw new IllegalArgumentException("Can't handle a null Control.");
        }
        try {
            if (control.matchesID(CHANGE_MODEL_CONTROL_ID)) {
                this.changeModel(control.getParameter());
            } else {
                ViewContext.getViewContext().startProgress();
                try {
                    this.doHandleControl(control);
                    Object var3_2 = null;
                    ViewContext.getViewContext().stopProgress();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    ViewContext.getViewContext().stopProgress();
                    throw throwable;
                }
            }
            if (!control.isMatched()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handleControl: not matched: " + control);
                }
                if (control.matchesID(EXIT_CONTROL_ID)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("handleControl: EXIT: " + this.getParent());
                    }
                    if (this.getParent() == null) {
                        if (ViewContext.getViewContext() == null) {
                            throw new RuntimeException("No ViewContext: setup at start of applicationusing ViewContext.");
                        }
                        ViewContext.getViewContext().exit();
                    } else {
                        control.setParameter(this);
                        control.markUnmatched();
                        this.passControlToParent(control);
                    }
                } else if (control.matchesID(HIDE_VIEW_CONTROL_ID)) {
                    this.hideView();
                } else {
                    this.passControlToParent(control);
                }
            }
            if (!control.isMatched()) {
                LOG.warn("Control not handled: " + control);
            }
        }
        catch (ControlException controlException) {
            control.markMatched();
            control.populateControlException(controlException);
            this.handleControlException(controlException);
        }
        catch (RuntimeException runtimeException) {
            LOG.error("Failed to handle Control: " + control, runtimeException);
            ControlException controlException = new ControlException(HANDLE_CONTROL_RUNTIME_ERROR_MSG_ID, (Object)runtimeException);
            control.markMatched();
            control.populateControlException(controlException);
            this.handleControlException(controlException);
        }
    }

    public void startup() {
        if (this.getView() != null) {
            this.showView();
        }
    }

    public void shutdown() {
        BasicController[] basicControllerArray = this.getChildren().toArray(new BasicController[0]);
        int n = 0;
        while (n < basicControllerArray.length) {
            basicControllerArray[n].shutdown();
            ++n;
        }
        this.hideView();
        this.setParent(null);
    }

    protected final void setParent(BasicController basicController) {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
        }
        this.parent = basicController;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
    }

    protected final void passControlToParent(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("Can't pass null Control to parent.");
        }
        BasicController basicController = this.parent;
        if (LOG.isDebugEnabled()) {
            LOG.debug("passControlToParent: to: " + basicController + " control: " + control);
        }
        if (basicController == null) {
            return;
        }
        basicController.handleControl(control);
    }

    protected final void showView() {
        this.showView(this.getView());
    }

    protected final void showView(View view) {
        if (view == null) {
            throw new RuntimeException("No View to show.");
        }
        if (ViewContext.getViewContext() == null) {
            throw new RuntimeException("No ViewContext: setup at start of application using ViewContext.");
        }
        try {
            ViewContext.getViewContext().showView(view);
        }
        catch (Exception exception) {
            LOG.error("Failed to showView: " + view, exception);
        }
    }

    protected final void hideView() {
        this.hideView(this.getView());
    }

    protected final void hideView(View view) {
        if (view == null) {
            throw new RuntimeException("No View to hide.");
        }
        if (ViewContext.getViewContext() == null) {
            throw new RuntimeException("No ViewContext: setup at start of application using ViewContext.");
        }
        try {
            ViewContext.getViewContext().hideView(view);
        }
        catch (Exception exception) {
            LOG.error("Failed to showView: " + view, exception);
        }
    }

    protected final void showError(String string, String string2) {
        if (ViewContext.getViewContext() == null) {
            throw new RuntimeException("No ViewContext: setup at start of application using ViewContext.");
        }
        ViewContext.getViewContext().showError(string, string2);
    }

    protected void bindModelToView(View view, Object object) {
        if (view == null) {
            return;
        }
        if (view instanceof PropertyView && ((PropertyView)view).getSelector() != null) {
            return;
        }
        view.setBoundModel(object);
    }

    protected void doHandleControl(Control control) throws ControlException {
    }

    protected void handleControlException(ControlException controlException) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleControlException: " + controlException);
        }
        if (controlException == null) {
            throw new IllegalArgumentException("Can't handle null ControlException.");
        }
        if (controlException == null) {
            this.showError(UIStrings.get("UnknownErrorTitle"), UIStrings.get("UnknownErrorMessage"));
        } else {
            this.showError(controlException.getLocalizedSourceControlName(), controlException.getLocalizedMessage());
        }
    }

    private void changeModel(Object object) {
        this.setModel(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

