/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.instrument;

import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.persistence.Persistence;
import org.apache.cayenne.instrument.JpaUnitNameParser;

public class CayenneAgent {
    private static final String JPA_EAGER_LOAD_ARG = "jpa-eager-load";
    static Instrumentation instrumentation;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (agentArgs != null) {
            System.out.println("*** CayenneAgent starting with arguments: " + agentArgs);
        } else {
            System.out.println("*** CayenneAgent starting...");
        }
        CayenneAgent.instrumentation = instrumentation;
        AgentOptions options = new AgentOptions(agentArgs);
        if (options.jpaEagerLoad) {
            Collection<String> jpaUnitNames = new JpaUnitNameParser().getUnitNames();
            for (String unit : jpaUnitNames) {
                Persistence.createEntityManagerFactory((String)unit).close();
            }
        }
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    static final class AgentOptions {
        boolean jpaEagerLoad;

        AgentOptions(String args) {
            if (args != null) {
                StringTokenizer toks = new StringTokenizer(args, ",");
                while (toks.hasMoreTokens()) {
                    String option = toks.nextToken();
                    if (!CayenneAgent.JPA_EAGER_LOAD_ARG.equals(option)) continue;
                    this.jpaEagerLoad = true;
                }
            }
        }
    }
}

