/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataMapListener;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.DataNodeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.map.event.DomainListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.ProcedureListener;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.map.event.QueryListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateDomainAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CutAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectTreeView
extends JTree
implements DomainDisplayListener,
DomainListener,
DataMapDisplayListener,
DataMapListener,
DataNodeDisplayListener,
DataNodeListener,
ObjEntityListener,
ObjEntityDisplayListener,
DbEntityListener,
DbEntityDisplayListener,
QueryListener,
QueryDisplayListener,
ProcedureListener,
ProcedureDisplayListener,
MultipleObjectsDisplayListener {
    private static final Log logObj = LogFactory.getLog(ProjectTreeView.class);
    protected ProjectController mediator;
    protected TreeSelectionListener treeSelectionListener;
    protected JPopupMenu popup;

    public ProjectTreeView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
        this.initFromModel(Application.getProject());
    }

    private void initView() {
        this.setCellRenderer(CellRenderers.treeRenderer());
    }

    private void initController() {
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] paths = ProjectTreeView.this.getSelectionPaths();
                if (paths != null) {
                    if (paths.length > 1) {
                        ProjectPath[] projectPaths = new ProjectPath[paths.length];
                        for (int i = 0; i < paths.length; ++i) {
                            projectPaths[i] = this.createProjectPath(paths[i]);
                        }
                        ProjectTreeView.this.mediator.fireMultipleObjectsDisplayEvent(new MultipleObjectsDisplayEvent(this, projectPaths));
                    } else if (paths.length == 1) {
                        ProjectTreeView.this.processSelection(paths[0]);
                    }
                }
            }

            private ProjectPath createProjectPath(TreePath treePath) {
                Object[] path = treePath.getPath();
                Object[] projectPath = new Object[path.length];
                for (int i = 0; i < projectPath.length; ++i) {
                    projectPath[i] = ((DefaultMutableTreeNode)path[i]).getUserObject();
                }
                return new ProjectPath(projectPath);
            }
        };
        this.addTreeSelectionListener(this.treeSelectionListener);
        this.addMouseListener(new PopupHandler());
        this.mediator.addDomainListener(this);
        this.mediator.addDomainDisplayListener(this);
        this.mediator.addDataNodeListener(this);
        this.mediator.addDataNodeDisplayListener(this);
        this.mediator.addDataMapListener(this);
        this.mediator.addDataMapDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addDbEntityListener(this);
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addProcedureListener(this);
        this.mediator.addProcedureDisplayListener(this);
        this.mediator.addQueryListener(this);
        this.mediator.addQueryDisplayListener(this);
        this.mediator.getApplication().getActionManager().setupCCP(this, CutAction.getActionName(), CopyAction.getActionName());
    }

    private void initFromModel(Project project) {
        ProjectTreeModel model = new ProjectTreeModel(project);
        this.setRootVisible(false);
        this.setModel(model);
        this.getSelectionModel().setSelectionMode(4);
        Enumeration<TreeNode> level = model.getRootNode().children();
        while (level.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)level.nextElement();
            TreePath path = new TreePath(node.getPath());
            this.expandPath(path);
        }
    }

    ProjectTreeModel getProjectModel() {
        return (ProjectTreeModel)this.getModel();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        while (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Project) {
            File f = ((Project)value).getMainFile();
            return f != null ? f.getPath() : "";
        }
        try {
            return value != null ? String.valueOf(PropertyUtils.getProperty((Object)value, (String)"name")) : "";
        }
        catch (Exception e) {
            String objectClass = value == null ? "(unknown)" : value.getClass().getName();
            logObj.warn((Object)("Exception reading property 'name', class " + objectClass), (Throwable)e);
            return "";
        }
    }

    public void currentDomainChanged(DomainDisplayEvent e) {
        if (!(e.getSource() != this && e.isDomainChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain()});
    }

    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        if (!(e.getSource() != this && e.isDataNodeChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataNode()});
    }

    public void currentDataMapChanged(DataMapDisplayEvent e) {
        if (!(e.getSource() != this && e.isDataMapChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap()});
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        e.setEntityChanged(true);
        this.currentEntityChanged(e);
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        e.setEntityChanged(true);
        this.currentEntityChanged(e);
    }

    protected void currentEntityChanged(EntityDisplayEvent e) {
        if (!(e.getSource() != this && e.isEntityChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getEntity()});
    }

    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        if (!(e.getSource() != this && e.isProcedureChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getProcedure()});
    }

    public void currentQueryChanged(QueryDisplayEvent e) {
        if (!(e.getSource() != this && e.isQueryChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getQuery()});
    }

    public void currentObjectsChanged(MultipleObjectsDisplayEvent e) {
    }

    public void procedureAdded(ProcedureEvent e) {
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{this.mediator.findDomain(e.getProcedure().getDataMap()), e.getProcedure().getDataMap()});
        if (node == null) {
            return;
        }
        Procedure procedure = e.getProcedure();
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(procedure, false);
        this.positionNode(node, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    public void procedureChanged(ProcedureEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{this.mediator.findDomain(e.getProcedure().getDataMap()), e.getProcedure().getDataMap(), e.getProcedure()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    public void procedureRemoved(ProcedureEvent e) {
        this.removeNode(new Object[]{this.mediator.findDomain(e.getProcedure().getDataMap()), e.getProcedure().getDataMap(), e.getProcedure()});
    }

    public void queryAdded(QueryEvent e) {
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap()), e.getDataMap()});
        if (node == null) {
            return;
        }
        Query query = e.getQuery();
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(query, false);
        this.positionNode(node, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    public void queryChanged(QueryEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap()), e.getQuery()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    public void queryRemoved(QueryEvent e) {
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap()), e.getDataMap(), e.getQuery()});
    }

    public void domainChanged(DomainEvent e) {
        Object[] path = new Object[]{e.getDomain()};
        this.updateNode(path);
        if (e.isNameChange()) {
            this.positionNode(path, Comparators.getNamedObjectComparator());
            this.showNode(path);
        }
    }

    public void domainAdded(DomainEvent e) {
        DataDomain dataDomain = e.getDomain();
        DefaultMutableTreeNode newNode = ProjectTreeModel.wrapProjectNode(dataDomain);
        this.positionNode(null, newNode, Comparators.getNamedObjectComparator());
        this.showNode(newNode);
    }

    public void domainRemoved(DomainEvent e) {
        this.removeNode(new Object[]{e.getDomain()});
    }

    public void dataNodeChanged(DataNodeEvent e) {
        block4: {
            int mapCount;
            Object[] maps;
            DefaultMutableTreeNode node;
            block6: {
                block5: {
                    node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataNode()), e.getDataNode()});
                    if (node == null) break block4;
                    if (!e.isNameChange()) break block5;
                    this.positionNode((DefaultMutableTreeNode)node.getParent(), node, Comparators.getDataDomainChildrenComparator());
                    this.showNode(node);
                    break block4;
                }
                this.getProjectModel().nodeChanged(node);
                maps = e.getDataNode().getDataMaps().toArray();
                mapCount = maps.length;
                if (mapCount <= node.getChildCount()) break block6;
                for (int i = 0; i < mapCount; ++i) {
                    boolean found = false;
                    for (int j = 0; j < node.getChildCount(); ++j) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                        if (maps[i] != child.getUserObject()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DefaultMutableTreeNode newMapNode = new DefaultMutableTreeNode(maps[i], false);
                    this.positionNode(node, newMapNode, Comparators.getNamedObjectComparator());
                    break block4;
                }
                break block4;
            }
            if (mapCount >= node.getChildCount()) break block4;
            for (int j = 0; j < node.getChildCount(); ++j) {
                boolean found = false;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                Object obj = child.getUserObject();
                for (int i = 0; i < mapCount; ++i) {
                    if (maps[i] != obj) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.removeNode(child);
                break;
            }
        }
    }

    public void dataNodeAdded(DataNodeEvent e) {
        if (e.getSource() == this) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataNode())});
        if (node == null) {
            return;
        }
        DataNode dataNode = e.getDataNode();
        DefaultMutableTreeNode currentNode = ProjectTreeModel.wrapProjectNode(dataNode);
        this.positionNode(node, currentNode, Comparators.getDataDomainChildrenComparator());
        this.showNode(currentNode);
    }

    public void dataNodeRemoved(DataNodeEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataNode()), e.getDataNode()});
    }

    public void dataMapChanged(DataMapEvent e) {
        Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap()), e.getDataMap()};
        this.updateNode(path);
        if (e.isNameChange()) {
            this.positionNode(path, Comparators.getDataDomainChildrenComparator());
            this.showNode(path);
        }
    }

    public void dataMapAdded(DataMapEvent e) {
        DefaultMutableTreeNode domainNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap())});
        DefaultMutableTreeNode newMapNode = ProjectTreeModel.wrapProjectNode(e.getDataMap());
        this.positionNode(domainNode, newMapNode, Comparators.getDataDomainChildrenComparator());
        this.showNode(newMapNode);
    }

    public void dataMapRemoved(DataMapEvent e) {
        DataMap map = e.getDataMap();
        DataDomain domain = e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getDataMap());
        this.removeNode(new Object[]{domain, map});
        Iterator nodes = new ArrayList(domain.getDataNodes()).iterator();
        while (nodes.hasNext()) {
            this.removeNode(new Object[]{domain, nodes.next(), map});
        }
    }

    public void objEntityChanged(EntityEvent e) {
        this.entityChanged(e);
    }

    public void objEntityAdded(EntityEvent e) {
        this.entityAdded(e);
    }

    public void objEntityRemoved(EntityEvent e) {
        this.entityRemoved(e);
    }

    public void dbEntityChanged(EntityEvent e) {
        this.entityChanged(e);
    }

    public void dbEntityAdded(EntityEvent e) {
        this.entityAdded(e);
    }

    public void dbEntityRemoved(EntityEvent e) {
        this.entityRemoved(e);
    }

    protected void entityChanged(EntityEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getEntity().getDataMap()), e.getEntity().getDataMap(), e.getEntity()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    protected void entityAdded(EntityEvent e) {
        Entity entity = e.getEntity();
        DefaultMutableTreeNode mapNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getEntity().getDataMap()), e.getEntity().getDataMap()});
        if (mapNode == null) {
            return;
        }
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(entity, false);
        this.positionNode(mapNode, currentNode, Comparators.getDataMapChildrenComparator());
    }

    protected void entityRemoved(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : this.mediator.findDomain(e.getEntity().getDataMap()), e.getEntity().getDataMap(), e.getEntity()});
    }

    protected void removeNode(DefaultMutableTreeNode toBeRemoved) {
        Object selectedNode = null;
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null) {
            selectedNode = selectionPath.getLastPathComponent();
        }
        if (toBeRemoved == selectedNode) {
            DefaultMutableTreeNode newSelection = toBeRemoved.getNextSibling();
            if (newSelection == null && (newSelection = toBeRemoved.getPreviousSibling()) == null && (newSelection = (DefaultMutableTreeNode)toBeRemoved.getParent()) == null && (newSelection = toBeRemoved.getNextNode()) == null) {
                newSelection = toBeRemoved.getPreviousNode();
            }
            this.showNode(newSelection);
        }
        this.getProjectModel().removeNodeFromParent(toBeRemoved);
    }

    protected void showNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.scrollPathToVisible(path);
        this.setSelectionPath(path);
    }

    protected void showNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node == null) {
            return;
        }
        this.showNode(node);
    }

    protected void updateNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node != null) {
            this.getProjectModel().nodeChanged(node);
        }
    }

    protected void removeNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public void processSelection(TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object[] data = this.getUserObjects(currentNode);
        if (data.length == 0) {
            this.mediator.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, null));
            return;
        }
        Object obj = data[data.length - 1];
        if (obj instanceof DataDomain) {
            this.mediator.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, (DataDomain)obj));
        } else if (obj instanceof DataMap) {
            if (data.length == 3) {
                this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(this, (DataMap)obj, (DataDomain)data[data.length - 3], (DataNode)data[data.length - 2]));
            } else if (data.length == 2) {
                this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent((Object)this, (DataMap)obj, (DataDomain)data[data.length - 2]));
            }
        } else if (obj instanceof DataNode) {
            if (data.length == 2) {
                this.mediator.fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, (DataDomain)data[data.length - 2], (DataNode)obj));
            }
        } else if (obj instanceof Entity) {
            EntityDisplayEvent e = new EntityDisplayEvent((Object)this, (Entity)obj);
            e.setUnselectAttributes(true);
            if (data.length == 4) {
                e.setDataMap((DataMap)data[data.length - 2]);
                e.setDomain((DataDomain)data[data.length - 4]);
                e.setDataNode((DataNode)data[data.length - 3]);
            } else if (data.length == 3) {
                e.setDataMap((DataMap)data[data.length - 2]);
                e.setDomain((DataDomain)data[data.length - 3]);
            }
            if (obj instanceof ObjEntity) {
                this.mediator.fireObjEntityDisplayEvent(e);
            } else if (obj instanceof DbEntity) {
                this.mediator.fireDbEntityDisplayEvent(e);
            }
        } else if (obj instanceof Procedure) {
            ProcedureDisplayEvent e = new ProcedureDisplayEvent((Object)this, (Procedure)obj, (DataMap)data[data.length - 2], (DataDomain)data[data.length - 3]);
            this.mediator.fireProcedureDisplayEvent(e);
        } else if (obj instanceof Query) {
            QueryDisplayEvent e = new QueryDisplayEvent((Object)this, (Query)obj, (DataMap)data[data.length - 2], (DataDomain)data[data.length - 3]);
            this.mediator.fireQueryDisplayEvent(e);
        }
        this.scrollPathToVisible(path);
    }

    private Object[] getUserObjects(DefaultMutableTreeNode node) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (!node.isRoot()) {
            list.add(0, node.getUserObject());
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return list.toArray();
    }

    private void positionNode(Object[] path, Comparator comparator) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node == null) {
            return;
        }
        this.positionNode(null, node, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void positionNode(MutableTreeNode parent, DefaultMutableTreeNode treeNode, Comparator comparator) {
        this.removeTreeSelectionListener(this.treeSelectionListener);
        try {
            this.getProjectModel().positionNode(parent, treeNode, comparator);
        }
        finally {
            this.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public TreeSelectionListener getTreeSelectionListener() {
        return this.treeSelectionListener;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.buildMenu(CreateDomainAction.getActionName()));
        popup.add(this.buildMenu(CreateNodeAction.getActionName()));
        popup.add(this.buildMenu(CreateDataMapAction.getActionName()));
        popup.add(this.buildMenu(CreateObjEntityAction.getActionName()));
        popup.add(this.buildMenu(CreateDbEntityAction.getActionName()));
        popup.add(this.buildMenu(CreateProcedureAction.getActionName()));
        popup.add(this.buildMenu(CreateQueryAction.getActionName()));
        popup.addSeparator();
        popup.add(this.buildMenu(ObjEntitySyncAction.getActionName()));
        popup.addSeparator();
        popup.add(this.buildMenu(RemoveAction.getActionName()));
        popup.addSeparator();
        popup.add(this.buildMenu(CutAction.getActionName()));
        popup.add(this.buildMenu(CopyAction.getActionName()));
        popup.add(this.buildMenu(PasteAction.getActionName()));
        return popup;
    }

    private JMenuItem buildMenu(String key) {
        return this.mediator.getApplication().getAction(key).buildMenu();
    }

    class PopupHandler
    extends MouseAdapter {
        PopupHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.mouseReleased(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row;
                if (ProjectTreeView.this.popup == null) {
                    ProjectTreeView.this.popup = ProjectTreeView.this.createJPopupMenu();
                }
                if ((row = ProjectTreeView.this.getRowForLocation(e.getX(), e.getY())) != -1 && !ProjectTreeView.this.isRowSelected(row)) {
                    ProjectTreeView.this.setSelectionRow(row);
                }
                ProjectTreeView.this.popup.show(ProjectTreeView.this, e.getX(), e.getY());
            }
        }
    }
}

