/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.util.CellRenderers;

public class FindDialogView
extends JDialog {
    private JButton okButton;
    private List entityButtons = new ArrayList();

    public FindDialogView(Map objEntityNames, Map dbEntityNames, Map attrNames, Map relatNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (objEntityNames.isEmpty() && dbEntityNames.isEmpty() && attrNames.isEmpty() && relatNames.isEmpty()) {
            panel.add(new JLabel("Nothing found!"));
        } else {
            panel.add(this.createResultPanel(objEntityNames, CellRenderers.iconForObject(new ObjEntity())));
            panel.add(this.createResultPanel(dbEntityNames, CellRenderers.iconForObject(new DbEntity())));
            panel.add(this.createResultPanel(attrNames, CellRenderers.iconForObject(new ObjAttribute())));
            panel.add(this.createResultPanel(relatNames, CellRenderers.iconForObject(new ObjRelationship())));
        }
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        okPanel.add(this.okButton);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(new JScrollPane(panel, 20, 30));
        contentPane.add((Component)okPanel, "South");
        contentPane.setPreferredSize(new Dimension(400, 325));
        this.setTitle("Search results");
    }

    private JPanel createResultPanel(Map names, Icon icon) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (Integer index : names.keySet()) {
            JButton b = new JButton((String)names.get(index), icon);
            b.setBorder(new EmptyBorder(2, 10, 2, 10));
            b.setModel(new EntityButtonModel(index));
            panel.add(b);
            this.entityButtons.add(b);
        }
        return panel;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public List getEntityButtons() {
        return this.entityButtons;
    }

    public class EntityButtonModel
    extends DefaultButtonModel {
        private Integer index;

        EntityButtonModel(Integer index) {
            this.index = index;
        }

        public Integer getIndex() {
            return this.index;
        }
    }
}

