/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.DbLoaderMergeDialog;
import org.apache.cayenne.modeler.dialog.db.DbLoaderOptionsDialog;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.util.DeleteRuleUpdater;
import org.apache.cayenne.modeler.util.LongRunningTask;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbLoaderHelper {
    private static Log logObj = LogFactory.getLog(DbLoaderHelper.class);
    private static final Collection EXCLUDED_TABLES = Arrays.asList("AUTO_PK_SUPPORT", "auto_pk_support");
    static DbLoaderMergeDialog mergeDialog;
    protected boolean overwritePreferenceSet;
    protected boolean overwritingEntities;
    protected boolean stoppingReverseEngineering;
    protected boolean existingMap;
    protected ProjectController mediator;
    protected String dbUserName;
    protected DbLoader loader;
    protected DataMap dataMap;
    protected String schemaName;
    protected String tableNamePattern;
    protected boolean loadProcedures;
    protected String procedureNamePattern;
    protected List schemas;
    protected String loadStatusNote;
    protected List<ObjEntity> addedObjEntities;

    static synchronized DbLoaderMergeDialog getMergeDialogInstance() {
        if (mergeDialog == null) {
            mergeDialog = new DbLoaderMergeDialog(Application.getFrame());
        }
        return mergeDialog;
    }

    public DbLoaderHelper(ProjectController mediator, Connection connection, DbAdapter adapter, String dbUserName) {
        this.dbUserName = dbUserName;
        this.mediator = mediator;
        this.loader = new DbLoader(connection, adapter, (DbLoaderDelegate)new LoaderDelegate());
    }

    public void setOverwritingEntities(boolean overwritePreference) {
        this.overwritingEntities = overwritePreference;
    }

    public void setOverwritePreferenceSet(boolean overwritePreferenceSet) {
        this.overwritePreferenceSet = overwritePreferenceSet;
    }

    public void setStoppingReverseEngineering(boolean stopReverseEngineering) {
        this.stoppingReverseEngineering = stopReverseEngineering;
    }

    public boolean isOverwritePreferenceSet() {
        return this.overwritePreferenceSet;
    }

    public boolean isOverwritingEntities() {
        return this.overwritingEntities;
    }

    public boolean isStoppingReverseEngineering() {
        return this.stoppingReverseEngineering;
    }

    public void execute() {
        this.stoppingReverseEngineering = false;
        LoadSchemasTask loadSchemasTask = new LoadSchemasTask(Application.getFrame(), "Loading Schemas");
        loadSchemasTask.startAndWait();
        if (this.stoppingReverseEngineering) {
            return;
        }
        final DbLoaderOptionsDialog dialog = new DbLoaderOptionsDialog(this.schemas, this.dbUserName, false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    dialog.setVisible(true);
                    dialog.dispose();
                }
            });
        }
        catch (Throwable th) {
            this.processException(th, "Error Reengineering Database");
            return;
        }
        if (dialog.getChoice() == 0) {
            return;
        }
        this.schemaName = dialog.getSelectedSchema();
        this.tableNamePattern = dialog.getTableNamePattern();
        this.loadProcedures = dialog.isLoadingProcedures();
        this.procedureNamePattern = dialog.getProcedureNamePattern();
        this.addedObjEntities = new ArrayList<ObjEntity>();
        this.loader.setNamingStrategy(dialog.getNamingStrategy());
        LoadDataMapTask loadDataMapTask = new LoadDataMapTask(Application.getFrame(), "Reengineering DB");
        loadDataMapTask.startAndWait();
    }

    protected void processException(final Throwable th, final String message) {
        logObj.info((Object)"Exception on reverse engineering", Util.unwindException((Throwable)th));
        this.cleanup();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(Application.getFrame(), th.getMessage(), message, 0);
            }
        });
    }

    protected void cleanup() {
        this.loadStatusNote = "Closing connection...";
        try {
            if (this.loader.getCon() != null) {
                this.loader.getCon().close();
            }
        }
        catch (SQLException e) {
            logObj.warn((Object)"Error closing connection.", (Throwable)e);
        }
    }

    final class LoadDataMapTask
    extends DbLoaderTask {
        public LoadDataMapTask(JFrame frame, String title) {
            super(frame, title);
        }

        protected void execute() {
            block11: {
                block10: {
                    DbLoaderHelper.this.loadStatusNote = "Preparing...";
                    DbLoaderHelper.this.dataMap = DbLoaderHelper.this.mediator.getCurrentDataMap();
                    boolean bl = DbLoaderHelper.this.existingMap = DbLoaderHelper.this.dataMap != null;
                    if (!DbLoaderHelper.this.existingMap) {
                        DbLoaderHelper.this.dataMap = (DataMap)NamedObjectFactory.createObject(DataMap.class, null);
                        DbLoaderHelper.this.dataMap.setName(NamedObjectFactory.createName(DataMap.class, (Object)DbLoaderHelper.this.mediator.getCurrentDataDomain()));
                        DbLoaderHelper.this.dataMap.setDefaultSchema(DbLoaderHelper.this.schemaName);
                    }
                    if (this.isCanceled()) {
                        return;
                    }
                    DbLoaderHelper.this.loadStatusNote = "Importing tables...";
                    try {
                        DbLoaderHelper.this.loader.loadDataMapFromDB(DbLoaderHelper.this.schemaName, DbLoaderHelper.this.tableNamePattern, DbLoaderHelper.this.dataMap);
                        for (int i = 0; i < DbLoaderHelper.this.addedObjEntities.size(); ++i) {
                            DeleteRuleUpdater.updateObjEntity(DbLoaderHelper.this.addedObjEntities.get(i));
                        }
                    }
                    catch (Throwable th) {
                        if (this.isCanceled()) break block10;
                        DbLoaderHelper.this.processException(th, "Error Reengineering Database");
                    }
                }
                if (DbLoaderHelper.this.loadProcedures) {
                    DbLoaderHelper.this.loadStatusNote = "Importing procedures...";
                    try {
                        DbLoaderHelper.this.loader.loadProceduresFromDB(DbLoaderHelper.this.schemaName, DbLoaderHelper.this.procedureNamePattern, DbLoaderHelper.this.dataMap);
                    }
                    catch (Throwable th) {
                        if (this.isCanceled()) break block11;
                        DbLoaderHelper.this.processException(th, "Error Reengineering Database");
                    }
                }
            }
            DbLoaderHelper.this.cleanup();
            DbLoaderHelper.this.loadStatusNote = "Updating view...";
            if (DbLoaderHelper.this.mediator.getCurrentDataMap() != null) {
                DbLoaderHelper.this.mediator.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), DbLoaderHelper.this.dataMap, 1));
                DbLoaderHelper.this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(Application.getFrame(), DbLoaderHelper.this.dataMap, DbLoaderHelper.this.mediator.getCurrentDataDomain(), DbLoaderHelper.this.mediator.getCurrentDataNode()));
            } else {
                DbLoaderHelper.this.mediator.addDataMap(Application.getFrame(), DbLoaderHelper.this.dataMap);
            }
        }
    }

    final class LoadSchemasTask
    extends DbLoaderTask {
        public LoadSchemasTask(JFrame frame, String title) {
            super(frame, title);
        }

        protected void execute() {
            DbLoaderHelper.this.loadStatusNote = "Loading available schemas...";
            try {
                DbLoaderHelper.this.schemas = DbLoaderHelper.this.loader.getSchemas();
            }
            catch (Throwable th) {
                DbLoaderHelper.this.processException(th, "Error Loading Schemas");
            }
        }
    }

    abstract class DbLoaderTask
    extends LongRunningTask {
        public DbLoaderTask(JFrame frame, String title) {
            super(frame, title);
            this.setMinValue(0);
            this.setMaxValue(10);
        }

        protected String getCurrentNote() {
            return DbLoaderHelper.this.loadStatusNote;
        }

        protected int getCurrentValue() {
            return this.getMinValue();
        }

        protected boolean isIndeterminate() {
            return true;
        }

        public boolean isCanceled() {
            return DbLoaderHelper.this.isStoppingReverseEngineering();
        }

        public void setCanceled(boolean b) {
            if (b) {
                DbLoaderHelper.this.loadStatusNote = "Canceling..";
            }
            DbLoaderHelper.this.setStoppingReverseEngineering(b);
        }
    }

    final class LoaderDelegate
    implements DbLoaderDelegate {
        LoaderDelegate() {
        }

        public boolean overwriteDbEntity(DbEntity ent) throws CayenneException {
            this.checkCanceled();
            if (!DbLoaderHelper.this.overwritePreferenceSet) {
                DbLoaderMergeDialog dialog = DbLoaderHelper.getMergeDialogInstance();
                dialog.initFromModel(DbLoaderHelper.this, ent.getName());
                dialog.centerWindow();
                dialog.setVisible(true);
                dialog.setVisible(false);
            }
            if (DbLoaderHelper.this.stoppingReverseEngineering) {
                throw new CayenneException("Should stop DB import.");
            }
            return DbLoaderHelper.this.overwritingEntities;
        }

        public void dbEntityAdded(DbEntity entity) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Importing table '" + entity.getName() + "'...";
            if (EXCLUDED_TABLES.contains(entity.getName()) && entity.getDataMap() != null) {
                entity.getDataMap().removeDbEntity(entity.getName());
            } else if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)entity, 2));
            }
        }

        public void objEntityAdded(ObjEntity entity) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Creating ObjEntity '" + entity.getName() + "'...";
            DbLoaderHelper.this.addedObjEntities.add(entity);
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 2));
            }
        }

        public void dbEntityRemoved(DbEntity entity) {
            this.checkCanceled();
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireDbEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
            }
        }

        public void objEntityRemoved(ObjEntity entity) {
            this.checkCanceled();
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireObjEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
            }
        }

        void checkCanceled() {
            if (DbLoaderHelper.this.isStoppingReverseEngineering()) {
                throw new CayenneRuntimeException("Reengineering was canceled.");
            }
        }
    }
}

