/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.modeler.dialog.pref.DBConnectionInfoEditorView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class DBConnectionInfoEditor
extends CayenneController {
    private static final DBConnectionInfo emptyInfo = new DBConnectionInfo();
    protected DBConnectionInfoEditorView view = new DBConnectionInfoEditorView();
    protected DBConnectionInfo connectionInfo;
    protected ObjectBinding[] bindings;

    public DBConnectionInfoEditor(CayenneController parent) {
        super(parent);
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.setEnabled(false);
        DefaultComboBoxModel<Object> adapterModel = new DefaultComboBoxModel<Object>(DbAdapterInfo.getStandardAdapters());
        this.view.getAdapters().setModel(adapterModel);
        this.view.getAdapters().setSelectedIndex(0);
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.bindings = new ObjectBinding[5];
        this.bindings[0] = builder.bindToTextField(this.view.getUserName(), "connectionInfo.userName");
        this.bindings[1] = builder.bindToTextField(this.view.getPassword(), "connectionInfo.password");
        this.bindings[2] = builder.bindToTextField(this.view.getDriver(), "connectionInfo.jdbcDriver");
        this.bindings[3] = builder.bindToTextField(this.view.getUrl(), "connectionInfo.url");
        this.bindings[4] = builder.bindToComboSelection(this.view.getAdapters(), "connectionInfo.dbAdapter", "Automatic");
    }

    public DBConnectionInfo getConnectionInfo() {
        return this.connectionInfo != null ? this.connectionInfo : emptyInfo;
    }

    public void setConnectionInfo(DBConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.refreshView();
    }

    protected void refreshView() {
        this.getView().setEnabled(this.connectionInfo != null);
        for (int i = 0; i < this.bindings.length; ++i) {
            this.bindings[i].updateView();
        }
    }
}

