/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectQueryOrderingTab;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;

public class SelectQueryPrefetchTab
extends SelectQueryOrderingTab {
    public SelectQueryPrefetchTab(ProjectController mediator) {
        super(mediator);
    }

    protected JComponent createToolbar() {
        JButton add = new JButton("Add Prefetch", ModelerUtil.buildIcon("icon-move_up.gif"));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectQueryPrefetchTab.this.addPrefetch();
            }
        });
        JButton remove = new JButton("Remove Prefetch", ModelerUtil.buildIcon("icon-move_down.gif"));
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectQueryPrefetchTab.this.removePrefetch();
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.add(add);
        toolbar.add(remove);
        return toolbar;
    }

    protected TreeModel createBrowserModel(Entity entity) {
        EntityTreeModel treeModel = new EntityTreeModel(entity);
        treeModel.setFilter(new EntityTreeFilter(){

            public boolean attributeMatch(Object node, Attribute attr) {
                return false;
            }

            public boolean relationshipMatch(Object node, Relationship rel) {
                return true;
            }
        });
        return treeModel;
    }

    protected TableModel createTableModel() {
        return new PrefetchModel();
    }

    void addPrefetch() {
        PrefetchTreeNode node;
        String prefetch = this.getSelectedPath();
        if (prefetch == null) {
            return;
        }
        if (this.selectQuery.getPrefetchTree() != null && (node = this.selectQuery.getPrefetchTree().getNode(prefetch)) != null && !node.isPhantom()) {
            return;
        }
        this.selectQuery.addPrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)this.selectQuery));
    }

    void removePrefetch() {
        int selection = this.table.getSelectedRow();
        if (selection < 0) {
            return;
        }
        String prefetch = (String)this.table.getModel().getValueAt(selection, 0);
        this.selectQuery.removePrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)this.selectQuery));
    }

    boolean isToMany(String prefetch) {
        if (this.selectQuery == null) {
            return false;
        }
        Object root = this.selectQuery.getRoot();
        try {
            Expression exp = Expression.fromString((String)prefetch);
            Object object = exp.evaluate(root);
            if (object instanceof Relationship) {
                return ((Relationship)object).isToMany();
            }
            return false;
        }
        catch (ExpressionException e) {
            return false;
        }
    }

    final class PrefetchModel
    extends AbstractTableModel {
        String[] prefetches;

        PrefetchModel() {
            if (SelectQueryPrefetchTab.this.selectQuery != null) {
                if (SelectQueryPrefetchTab.this.selectQuery.getPrefetchTree() == null) {
                    this.prefetches = new String[0];
                } else {
                    Collection c = SelectQueryPrefetchTab.this.selectQuery.getPrefetchTree().nonPhantomNodes();
                    this.prefetches = new String[c.size()];
                    Iterator it = c.iterator();
                    for (int i = 0; i < this.prefetches.length; ++i) {
                        this.prefetches[i] = ((PrefetchTreeNode)it.next()).getPath();
                    }
                }
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.prefetches != null ? this.prefetches.length : 0;
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.prefetches[row];
                }
                case 1: {
                    return SelectQueryPrefetchTab.this.isToMany(this.prefetches[row]) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Prefetch Path";
                }
                case 1: {
                    return "To Many";
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

