/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CayenneTableModel
extends AbstractTableModel {
    protected ProjectController mediator;
    protected Object eventSource;
    protected List objectList;
    private static Log logObj = LogFactory.getLog(CayenneTableModel.class);

    public CayenneTableModel(ProjectController mediator, Object eventSource, List objectList) {
        this.eventSource = eventSource;
        this.mediator = mediator;
        this.objectList = objectList;
        this.orderList();
    }

    @Override
    public void setValueAt(Object newVal, int row, int col) {
        try {
            if (!Util.nullSafeEquals((Object)newVal, (Object)this.getValueAt(row, col))) {
                this.setUpdatedValueAt(newVal, row, col);
            }
        }
        catch (IllegalArgumentException e) {
            logObj.error((Object)"Error setting table model value", (Throwable)e);
            JOptionPane.showMessageDialog(Application.getFrame(), e.getMessage(), "Invalid value", 0);
        }
    }

    public abstract void setUpdatedValueAt(Object var1, int var2, int var3);

    protected void orderList() {
        String key = this.getOrderingKey();
        if (key != null) {
            Collections.sort(this.objectList, new PropertyComparator(this.getOrderingKey(), this.getElementsClass()));
        }
    }

    public abstract Class<?> getElementsClass();

    public String getOrderingKey() {
        return "name";
    }

    @Override
    public int getRowCount() {
        return this.objectList.size();
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public ProjectController getMediator() {
        return this.mediator;
    }

    public List getObjectList() {
        return this.objectList;
    }

    public void addRow(Object row) {
        this.objectList.add(row);
        this.fireTableDataChanged();
    }

    public void removeRow(Object row) {
        this.objectList.remove(row);
        this.fireTableDataChanged();
    }

    public int moveRowUp(Object row) {
        int len = this.objectList.size();
        if (len < 2) {
            return -1;
        }
        int ind = this.objectList.indexOf(row);
        if (ind <= 0) {
            return -1;
        }
        int neighborIndex = ind - 1;
        if (neighborIndex < 0) {
            neighborIndex = len - 1;
        }
        this.swapRows(ind, neighborIndex);
        return neighborIndex;
    }

    public int moveRowDown(Object row) {
        int len = this.objectList.size();
        if (len < 2) {
            return -1;
        }
        int ind = this.objectList.indexOf(row);
        if (ind < 0 || ind + 1 >= len) {
            return -1;
        }
        int neighborIndex = ind + 1;
        this.swapRows(ind, neighborIndex);
        return neighborIndex;
    }

    protected void swapRows(int i, int j) {
        Collections.swap(this.objectList, i, j);
        this.fireTableDataChanged();
    }

    class PropertyComparator
    implements Comparator {
        Method getter;

        PropertyComparator(String propertyName, Class beanClass) {
            try {
                this.getter = this.findGetter(beanClass, propertyName);
            }
            catch (IntrospectionException e) {
                throw new CayenneRuntimeException("Introspection error", (Throwable)e);
            }
        }

        Method findGetter(Class beanClass, String propertyName) throws IntrospectionException {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                if (!propertyName.equals(descriptors[i].getName())) continue;
                return descriptors[i].getReadMethod();
            }
            throw new IntrospectionException("No getter found for " + propertyName);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null || o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            try {
                Comparable p1 = (Comparable)this.getter.invoke(o1, null);
                Comparable p2 = (Comparable)this.getter.invoke(o2, null);
                return p1 == null ? -1 : p1.compareTo(p2);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error reading property.", (Throwable)ex);
            }
        }
    }
}

