/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.pref.CayennePreferenceService;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.DomainPreference;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.pref.PreferenceService;

public abstract class CayennePreferenceEditor
implements PreferenceEditor {
    protected CayennePreferenceService service;
    protected DataContext editingContext;
    protected boolean restartRequired;
    protected int saveInterval;

    public CayennePreferenceEditor(CayennePreferenceService service) {
        this.service = service;
        this.editingContext = service.getDataContext().getParentDataDomain().createDataContext();
        this.saveInterval = service.getSaveInterval();
    }

    protected boolean isRestartRequired() {
        return this.restartRequired;
    }

    protected void setRestartRequired(boolean restartOnSave) {
        this.restartRequired = restartOnSave;
    }

    protected DataContext getEditingContext() {
        return this.editingContext;
    }

    public Domain editableInstance(Domain object) {
        if (object.getObjectContext() == this.getEditingContext()) {
            return object;
        }
        return (Domain)this.getEditingContext().localObject(object.getObjectId(), null);
    }

    public PreferenceDetail createDetail(Domain domain, String key) {
        domain = this.editableInstance(domain);
        DomainPreference preference = (DomainPreference)((Object)this.getEditingContext().newObject(DomainPreference.class));
        preference.setDomain(domain);
        preference.setKey(key);
        return preference.getPreference();
    }

    public PreferenceDetail createDetail(Domain domain, String key, Class javaClass) {
        domain = this.editableInstance(domain);
        DomainPreference preferenceLink = (DomainPreference)((Object)this.getEditingContext().newObject(DomainPreference.class));
        preferenceLink.setDomain(domain);
        preferenceLink.setKey(key);
        PreferenceDetail detail = (PreferenceDetail)((Object)this.getEditingContext().newObject(javaClass));
        detail.setDomainPreference(preferenceLink);
        return detail;
    }

    public PreferenceDetail deleteDetail(Domain domain, String key) {
        PreferenceDetail detail = (domain = this.editableInstance(domain)).getDetail(key, false);
        if (detail != null) {
            DomainPreference preference = detail.getDomainPreference();
            preference.setDomain(null);
            this.getEditingContext().deleteObject((Object)preference);
            this.getEditingContext().deleteObject((Object)detail);
        }
        return detail;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public void setSaveInterval(int ms) {
        if (this.saveInterval != ms) {
            this.saveInterval = ms;
            this.restartRequired = true;
        }
    }

    public PreferenceService getService() {
        return this.service;
    }

    public void save() {
        this.service.setSaveInterval(this.saveInterval);
        this.editingContext.commitChanges();
        if (this.restartRequired) {
            this.restart();
        }
    }

    public void revert() {
        this.editingContext.rollbackChanges();
        this.restartRequired = false;
    }

    protected abstract void restart();
}

