/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataMapListener;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.DataNodeListener;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.map.event.DomainListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.ProcedureListener;
import org.apache.cayenne.map.event.ProcedureParameterEvent;
import org.apache.cayenne.map.event.ProcedureParameterListener;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.map.event.QueryListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectWatchdog;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.event.CallbackMethodListener;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbAttributeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DbRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.DisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.event.EntityListenerListener;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjAttributeDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ObjRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CircularArray;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.IDUtil;

public class ProjectController
extends CayenneController {
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean dirty;
    protected Project project;
    protected Domain projectPreferences;
    protected ControllerState currentState;
    protected CircularArray controllerStateHistory = new CircularArray(this.maxHistorySize);
    protected int maxHistorySize = 20;
    protected ProjectWatchdog watchdog;

    public ProjectController(CayenneModelerController parent) {
        super(parent);
        this.currentState = new ControllerState();
    }

    public Component getView() {
        return this.parent.getView();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project currentProject) {
        if (this.project != currentProject) {
            this.project = currentProject;
            this.projectPreferences = null;
            if (this.project == null) {
                if (this.watchdog != null) {
                    this.watchdog.interrupt();
                    this.watchdog = null;
                }
            } else {
                if (this.watchdog == null) {
                    this.watchdog = new ProjectWatchdog(this);
                    this.watchdog.start();
                }
                this.watchdog.reconfigure();
            }
        }
    }

    public Domain getApplicationPreferenceDomain() {
        return this.getApplication().getPreferenceDomain();
    }

    public Domain getPreferenceDomainForProject() {
        if (this.getProject() == null) {
            throw new CayenneRuntimeException("No Project selected");
        }
        if (this.projectPreferences == null) {
            String key = this.getProject().isLocationUndefined() ? new String(IDUtil.pseudoUniqueByteSequence16()) : this.project.getMainFile().getAbsolutePath();
            this.projectPreferences = this.getApplicationPreferenceDomain().getSubdomain(Project.class).getSubdomain(key);
        }
        return this.projectPreferences;
    }

    public Domain getPreferenceDomainForDataDomain() {
        DataDomain dataDomain = this.getCurrentDataDomain();
        if (dataDomain == null) {
            throw new CayenneRuntimeException("No DataDomain selected");
        }
        return this.getPreferenceDomainForProject().getSubdomain(DataDomain.class).getSubdomain(dataDomain.getName());
    }

    public DataMapDefaults getDataMapPreferences(String nameSuffix) {
        DataMap map = this.getCurrentDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap selected");
        }
        if (nameSuffix == null) {
            nameSuffix = "";
        }
        return (DataMapDefaults)this.getPreferenceDomainForDataDomain().getDetail(map.getName() + nameSuffix, DataMapDefaults.class, true);
    }

    public DataNodeDefaults getDataNodePreferences() {
        DataNode node = this.getCurrentDataNode();
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode selected");
        }
        return (DataNodeDefaults)this.getPreferenceDomainForDataDomain().getDetail(node.getName(), DataNodeDefaults.class, true);
    }

    public void projectOpened() {
        CayenneModelerFrame frame = (CayenneModelerFrame)this.getView();
        this.addDataNodeDisplayListener(frame);
        this.addDataMapDisplayListener(frame);
        this.addObjEntityDisplayListener(frame);
        this.addDbEntityDisplayListener(frame);
        this.addQueryDisplayListener(frame);
        this.addProcedureDisplayListener(frame);
        this.addMultipleObjectsDisplayListener(frame);
    }

    public void reset() {
        this.clearState();
        this.setDirty(false);
        this.listenerList = new EventListenerList();
        this.controllerStateHistory.clear();
    }

    public void setHistorySize(int newSize) {
        this.controllerStateHistory.resize(newSize);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void clearState() {
        if (this.currentState.isRefiring) {
            return;
        }
        this.currentState = new ControllerState();
    }

    private void saveState(DisplayEvent e) {
        if (!this.controllerStateHistory.contains(this.currentState)) {
            this.currentState.event = e;
            this.controllerStateHistory.add(this.currentState);
        }
    }

    protected void refreshNamespace() {
        this.refreshNamespace(this.getCurrentDataDomain());
    }

    protected void refreshNamespace(DataDomain domain) {
        if (domain != null) {
            domain.getEntityResolver().clearCache();
        }
    }

    public DataDomain findDomain(DataNode node) {
        Collection domains = ((ApplicationProject)this.getProject()).getConfiguration().getDomains();
        for (DataDomain domain : domains) {
            if (domain.getNode(node.getName()) != node) continue;
            return domain;
        }
        return null;
    }

    public DataDomain findDomain(DataMap map) {
        Collection domains = ((ApplicationProject)this.getProject()).getConfiguration().getDomains();
        if (map == null) {
            map = this.getCurrentDataMap();
        }
        for (DataDomain domain : domains) {
            if (domain.getMap(map.getName()) != map) continue;
            return domain;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromHistory(EventObject e) {
        CircularArray circularArray = this.controllerStateHistory;
        synchronized (circularArray) {
            int count = this.controllerStateHistory.size();
            ArrayList<ControllerState> removeList = new ArrayList<ControllerState>();
            for (int i = 0; i < count; ++i) {
                ControllerState cs = (ControllerState)this.controllerStateHistory.get(i);
                DisplayEvent csEvent = cs.event;
                if (csEvent == null) continue;
                if (e instanceof EntityEvent && csEvent instanceof EntityDisplayEvent) {
                    if (((EntityEvent)e).getEntity() != ((EntityDisplayEvent)csEvent).getEntity()) continue;
                    removeList.add(cs);
                    continue;
                }
                if (e instanceof ProcedureEvent && csEvent instanceof ProcedureDisplayEvent) {
                    if (((ProcedureEvent)e).getProcedure() != ((ProcedureDisplayEvent)csEvent).getProcedure()) continue;
                    removeList.add(cs);
                    continue;
                }
                if (e instanceof QueryEvent && csEvent instanceof QueryDisplayEvent) {
                    if (((QueryEvent)e).getQuery() != ((QueryDisplayEvent)csEvent).getQuery()) continue;
                    removeList.add(cs);
                    continue;
                }
                if (e instanceof DataMapEvent && csEvent instanceof DataMapDisplayEvent) {
                    if (((DataMapEvent)e).getDataMap() != ((DataMapDisplayEvent)csEvent).getDataMap()) continue;
                    removeList.add(cs);
                    continue;
                }
                if (e instanceof DataNodeEvent && csEvent instanceof DataNodeDisplayEvent) {
                    if (((DataNodeEvent)e).getDataNode() != ((DataNodeDisplayEvent)csEvent).getDataNode()) continue;
                    removeList.add(cs);
                    continue;
                }
                if (!(e instanceof DomainEvent) || !(csEvent instanceof DomainDisplayEvent) || ((DomainEvent)e).getDomain() != ((DomainDisplayEvent)csEvent).getDomain()) continue;
                removeList.add(cs);
            }
            Iterator it = removeList.iterator();
            while (it.hasNext()) {
                this.controllerStateHistory.remove(it.next());
            }
        }
    }

    public DataNode getCurrentDataNode() {
        return this.currentState.node;
    }

    public DataDomain getCurrentDataDomain() {
        return this.currentState.domain;
    }

    public DataMap getCurrentDataMap() {
        return this.currentState.map;
    }

    public ObjEntity getCurrentObjEntity() {
        return this.currentState.objEntity;
    }

    public DbEntity getCurrentDbEntity() {
        return this.currentState.dbEntity;
    }

    public ObjAttribute[] getCurrentObjAttributes() {
        return this.currentState.objAttrs;
    }

    public DbAttribute[] getCurrentDbAttributes() {
        return this.currentState.dbAttrs;
    }

    public ObjRelationship[] getCurrentObjRelationships() {
        return this.currentState.objRels;
    }

    public DbRelationship[] getCurrentDbRelationships() {
        return this.currentState.dbRels;
    }

    public Query getCurrentQuery() {
        return this.currentState.query;
    }

    public Procedure getCurrentProcedure() {
        return this.currentState.procedure;
    }

    public ProcedureParameter[] getCurrentProcedureParameters() {
        return this.currentState.procedureParameters;
    }

    public ProjectPath[] getCurrentPaths() {
        return this.currentState.paths;
    }

    public void addDomainDisplayListener(DomainDisplayListener listener) {
        this.listenerList.add(DomainDisplayListener.class, listener);
    }

    public void addDomainListener(DomainListener listener) {
        this.listenerList.add(DomainListener.class, listener);
    }

    public void addDataNodeDisplayListener(DataNodeDisplayListener listener) {
        this.listenerList.add(DataNodeDisplayListener.class, listener);
    }

    public void addDataNodeListener(DataNodeListener listener) {
        this.listenerList.add(DataNodeListener.class, listener);
    }

    public void addDataMapDisplayListener(DataMapDisplayListener listener) {
        this.listenerList.add(DataMapDisplayListener.class, listener);
    }

    public void addDataMapListener(DataMapListener listener) {
        this.listenerList.add(DataMapListener.class, listener);
    }

    public void addDbEntityListener(DbEntityListener listener) {
        this.listenerList.add(DbEntityListener.class, listener);
    }

    public void addObjEntityListener(ObjEntityListener listener) {
        this.listenerList.add(ObjEntityListener.class, listener);
    }

    public void addDbEntityDisplayListener(DbEntityDisplayListener listener) {
        this.listenerList.add(DbEntityDisplayListener.class, listener);
    }

    public void addObjEntityDisplayListener(ObjEntityDisplayListener listener) {
        this.listenerList.add(ObjEntityDisplayListener.class, listener);
    }

    public void addDbAttributeListener(DbAttributeListener listener) {
        this.listenerList.add(DbAttributeListener.class, listener);
    }

    public void addDbAttributeDisplayListener(DbAttributeDisplayListener listener) {
        this.listenerList.add(DbAttributeDisplayListener.class, listener);
    }

    public void addObjAttributeListener(ObjAttributeListener listener) {
        this.listenerList.add(ObjAttributeListener.class, listener);
    }

    public void addObjAttributeDisplayListener(ObjAttributeDisplayListener listener) {
        this.listenerList.add(ObjAttributeDisplayListener.class, listener);
    }

    public void addDbRelationshipListener(DbRelationshipListener listener) {
        this.listenerList.add(DbRelationshipListener.class, listener);
    }

    public void addDbRelationshipDisplayListener(DbRelationshipDisplayListener listener) {
        this.listenerList.add(DbRelationshipDisplayListener.class, listener);
    }

    public void addObjRelationshipListener(ObjRelationshipListener listener) {
        this.listenerList.add(ObjRelationshipListener.class, listener);
    }

    public void addObjRelationshipDisplayListener(ObjRelationshipDisplayListener listener) {
        this.listenerList.add(ObjRelationshipDisplayListener.class, listener);
    }

    public void addQueryDisplayListener(QueryDisplayListener listener) {
        this.listenerList.add(QueryDisplayListener.class, listener);
    }

    public void addQueryListener(QueryListener listener) {
        this.listenerList.add(QueryListener.class, listener);
    }

    public void addProcedureDisplayListener(ProcedureDisplayListener listener) {
        this.listenerList.add(ProcedureDisplayListener.class, listener);
    }

    public void addProcedureListener(ProcedureListener listener) {
        this.listenerList.add(ProcedureListener.class, listener);
    }

    public void addProcedureParameterListener(ProcedureParameterListener listener) {
        this.listenerList.add(ProcedureParameterListener.class, listener);
    }

    public void addProcedureParameterDisplayListener(ProcedureParameterDisplayListener listener) {
        this.listenerList.add(ProcedureParameterDisplayListener.class, listener);
    }

    public void addMultipleObjectsDisplayListener(MultipleObjectsDisplayListener listener) {
        this.listenerList.add(MultipleObjectsDisplayListener.class, listener);
    }

    public void fireDomainDisplayEvent(DomainDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDomain() != this.currentState.domain;
        if (!changed) {
            boolean bl2 = changed = this.currentState.node != null || this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null;
        }
        if (!e.isRefired()) {
            e.setDomainChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(DomainDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            DomainDisplayListener temp = (DomainDisplayListener)list[i];
            temp.currentDomainChanged(e);
        }
        if (e.getDomain() == null) {
            this.getApplication().getActionManager().projectOpened();
        } else {
            this.getApplication().getActionManager().domainSelected();
        }
    }

    public void fireDomainEvent(DomainEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(DomainListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DomainListener temp = (DomainListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.domainAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.domainChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.domainRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DomainEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataNodeDisplayEvent(DataNodeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDataNode() != this.currentState.node;
        if (!changed) {
            boolean bl2 = changed = this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null;
        }
        if (!e.isRefired()) {
            e.setDataNodeChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(DataNodeDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ((DataNodeDisplayListener)list[i]).currentDataNodeChanged(e);
        }
    }

    public void fireDataNodeEvent(DataNodeEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(DataNodeListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DataNodeListener temp = (DataNodeListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.dataNodeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dataNodeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dataNodeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataNodeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataMapDisplayEvent(DataMapDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDataMap() != this.currentState.map;
        if (!changed) {
            boolean bl2 = changed = this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null;
        }
        if (!e.isRefired()) {
            e.setDataMapChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(DataMapDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            DataMapDisplayListener temp = (DataMapDisplayListener)list[i];
            temp.currentDataMapChanged(e);
        }
    }

    public void fireDataMapEvent(DataMapEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(DataMapListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DataMapListener listener = (DataMapListener)list[i];
            switch (e.getId()) {
                case 2: {
                    listener.dataMapAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dataMapChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dataMapRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataMapEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().objEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(ObjEntityListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            ObjEntityListener temp = (ObjEntityListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.objEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().dbEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(DbEntityListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DbEntityListener temp = (DbEntityListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.dbEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireQueryEvent(QueryEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(QueryListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            QueryListener listener = (QueryListener)list[i];
            switch (e.getId()) {
                case 2: {
                    listener.queryAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.queryChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.queryRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureEvent(ProcedureEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.refreshNamespace(e.getDomain());
            this.removeFromHistory((EventObject)e);
        }
        EventListener[] list = this.listenerList.getListeners(ProcedureListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            ProcedureListener listener = (ProcedureListener)list[i];
            switch (e.getId()) {
                case 2: {
                    listener.procedureAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.procedureChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.procedureRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureParameterEvent(ProcedureParameterEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(ProcedureParameterListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            ProcedureParameterListener listener = (ProcedureParameterListener)list[i];
            switch (e.getId()) {
                case 2: {
                    listener.procedureParameterAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.procedureParameterChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.procedureParameterRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureParameterEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireNavigationEvent(EventObject e) {
        int counter;
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        int size = this.controllerStateHistory.size();
        if (size == 0) {
            return;
        }
        int i = this.controllerStateHistory.indexOf(this.currentState);
        ControllerState cs = null;
        if (size == 1) {
            cs = (ControllerState)this.controllerStateHistory.get(0);
        } else if (source instanceof NavigateForwardAction) {
            counter = 0;
            while ((cs = i < 0 ? (ControllerState)this.controllerStateHistory.get(0) : (i + 1 < size ? (ControllerState)this.controllerStateHistory.get(i + 1) : (ControllerState)this.controllerStateHistory.get(0))).isEquivalent(this.currentState) && ++counter <= 5) {
                ++i;
            }
        } else if (source instanceof NavigateBackwardAction) {
            counter = 0;
            while (true) {
                if (i < 0) {
                    try {
                        cs = (ControllerState)this.controllerStateHistory.get(size - 2);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        cs = (ControllerState)this.controllerStateHistory.get(size - 1);
                    }
                } else {
                    cs = i - 1 >= 0 ? (ControllerState)this.controllerStateHistory.get(i - 1) : (ControllerState)this.controllerStateHistory.get(size - 1);
                }
                if (!cs.isEquivalent(this.currentState) || ++counter > 5) break;
                --i;
            }
        }
        this.currentState = cs;
        DisplayEvent de = cs.event;
        if (de == null) {
            return;
        }
        this.currentState.isRefiring = true;
        de.setRefired(true);
        if (de instanceof EntityDisplayEvent) {
            EntityDisplayEvent ede = (EntityDisplayEvent)de;
            ede.setEntityChanged(true);
            if (ede.getEntity() instanceof ObjEntity) {
                this.fireObjEntityDisplayEvent(ede);
            } else if (ede.getEntity() instanceof DbEntity) {
                this.fireDbEntityDisplayEvent(ede);
            }
        } else if (de instanceof ProcedureDisplayEvent) {
            ProcedureDisplayEvent pde = (ProcedureDisplayEvent)de;
            pde.setProcedureChanged(true);
            this.fireProcedureDisplayEvent(pde);
        } else if (de instanceof QueryDisplayEvent) {
            QueryDisplayEvent qde = (QueryDisplayEvent)de;
            qde.setQueryChanged(true);
            this.fireQueryDisplayEvent(qde);
        } else if (de instanceof DataMapDisplayEvent) {
            DataMapDisplayEvent dmde = (DataMapDisplayEvent)de;
            dmde.setDataMapChanged(true);
            this.fireDataMapDisplayEvent(dmde);
        } else if (de instanceof DataNodeDisplayEvent) {
            DataNodeDisplayEvent dnde = (DataNodeDisplayEvent)de;
            dnde.setDataNodeChanged(true);
            this.fireDataNodeDisplayEvent(dnde);
        } else if (de instanceof DomainDisplayEvent) {
            DomainDisplayEvent dde = (DomainDisplayEvent)de;
            dde.setDomainChanged(true);
            this.fireDomainDisplayEvent(dde);
        }
        this.currentState.isRefiring = false;
    }

    public void fireObjEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.objEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(ObjEntityDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ObjEntityDisplayListener temp = (ObjEntityDisplayListener)list[i];
            temp.currentObjEntityChanged(e);
        }
    }

    public void fireQueryDisplayEvent(QueryDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getQuery() != this.currentState.query;
        if (!e.isRefired()) {
            e.setQueryChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.query = e.getQuery();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(QueryDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            QueryDisplayListener listener = (QueryDisplayListener)list[i];
            listener.currentQueryChanged(e);
        }
    }

    public void fireProcedureDisplayEvent(ProcedureDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getProcedure() != this.currentState.procedure;
        if (!e.isRefired()) {
            e.setProcedureChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(ProcedureDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ProcedureDisplayListener listener = (ProcedureDisplayListener)list[i];
            listener.currentProcedureChanged(e);
        }
    }

    public void fireProcedureParameterDisplayEvent(ProcedureParameterDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getProcedureParameters(), this.currentState.procedureParameters);
        if (changed) {
            if (this.currentState.procedure != e.getProcedure()) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
            ControllerState.access$1302(this.currentState, e.getProcedureParameters());
        }
        EventListener[] list = this.listenerList.getListeners(ProcedureParameterDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ProcedureParameterDisplayListener listener = (ProcedureParameterDisplayListener)list[i];
            listener.currentProcedureParameterChanged(e);
        }
    }

    public void fireDbEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.dbEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EventListener[] list = this.listenerList.getListeners(DbEntityDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            DbEntityDisplayListener temp = (DbEntityDisplayListener)list[i];
            temp.currentDbEntityChanged(e);
        }
    }

    public void fireDbAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(DbAttributeListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DbAttributeListener temp = (DbAttributeListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.dbAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbAttributeDisplayEvent(AttributeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.dbAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            ControllerState.access$802(this.currentState, new DbAttribute[e.getAttributes().length]);
            System.arraycopy(e.getAttributes(), 0, this.currentState.dbAttrs, 0, this.currentState.dbAttrs.length);
        }
        EventListener[] list = this.listenerList.getListeners(DbAttributeDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            DbAttributeDisplayListener temp = (DbAttributeDisplayListener)list[i];
            temp.currentDbAttributeChanged(e);
        }
    }

    public void fireObjAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(ObjAttributeListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            ObjAttributeListener temp = (ObjAttributeListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.objAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjAttributeDisplayEvent(AttributeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.objAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            ControllerState.access$702(this.currentState, new ObjAttribute[e.getAttributes().length]);
            System.arraycopy(e.getAttributes(), 0, this.currentState.objAttrs, 0, this.currentState.objAttrs.length);
        }
        EventListener[] list = this.listenerList.getListeners(ObjAttributeDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ObjAttributeDisplayListener temp = (ObjAttributeDisplayListener)list[i];
            temp.currentObjAttributeChanged(e);
        }
    }

    public void fireDbRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        if (e.getId() == 1 && e.getEntity() instanceof DbEntity) {
            ((DbEntity)e.getEntity()).dbRelationshipChanged(e);
        }
        EventListener[] list = this.listenerList.getListeners(DbRelationshipListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            DbRelationshipListener temp = (DbRelationshipListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.dbRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getRelationships(), this.currentState.dbRels);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            ControllerState.access$1002(this.currentState, new DbRelationship[e.getRelationships().length]);
            System.arraycopy(e.getRelationships(), 0, this.currentState.dbRels, 0, this.currentState.dbRels.length);
        }
        EventListener[] list = this.listenerList.getListeners(DbRelationshipDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            DbRelationshipDisplayListener temp = (DbRelationshipDisplayListener)list[i];
            temp.currentDbRelationshipChanged(e);
        }
    }

    public void fireObjRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(ObjRelationshipListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            ObjRelationshipListener temp = (ObjRelationshipListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.objRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireMultipleObjectsDisplayEvent(MultipleObjectsDisplayEvent e) {
        this.clearState();
        ControllerState.access$1402(this.currentState, e.getPaths());
        EventListener[] list = this.listenerList.getListeners(MultipleObjectsDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            MultipleObjectsDisplayListener temp = (MultipleObjectsDisplayListener)list[i];
            temp.currentObjectsChanged(e);
        }
    }

    public void fireObjRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        boolean changed = !Arrays.equals(e.getRelationships(), this.currentState.objRels);
        e.setRelationshipChanged(changed);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            ControllerState.access$902(this.currentState, new ObjRelationship[e.getRelationships().length]);
            System.arraycopy(e.getRelationships(), 0, this.currentState.objRels, 0, this.currentState.objRels.length);
        }
        EventListener[] list = this.listenerList.getListeners(ObjRelationshipDisplayListener.class);
        for (int i = 0; i < list.length; ++i) {
            ObjRelationshipDisplayListener temp = (ObjRelationshipDisplayListener)list[i];
            temp.currentObjRelationshipChanged(e);
        }
    }

    public void addDataMap(Object src, DataMap map) {
        this.addDataMap(src, map, true);
    }

    public void addDataMap(Object src, DataMap map, boolean makeCurrent) {
        this.currentState.domain.addMap(map);
        if (this.currentState.node != null && !this.currentState.node.getDataMaps().contains(map)) {
            this.currentState.node.addDataMap(map);
            this.fireDataNodeEvent(new DataNodeEvent((Object)this, this.currentState.node));
            this.currentState.domain.reindexNodes();
        }
        this.fireDataMapEvent(new DataMapEvent(src, map, 2));
        if (makeCurrent) {
            this.fireDataMapDisplayEvent(new DataMapDisplayEvent(src, map, this.currentState.domain, this.currentState.node));
        }
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.application.getAction(SaveAction.getActionName()).setEnabled(dirty);
            this.application.getAction(RevertAction.getActionName()).setEnabled(dirty);
            if (dirty) {
                ((CayenneModelerController)this.getParent()).projectModifiedAction();
            }
        }
    }

    public String getCurrentListenerClass() {
        return this.currentState.listenerClass;
    }

    public CallbackType getCurrentCallbackType() {
        return this.currentState.callbackType;
    }

    public String[] getCurrentCallbackMethods() {
        return this.currentState.callbackMethods;
    }

    public void setCurrentListenerClass(String listenerClass) {
        this.currentState.listenerClass = listenerClass;
    }

    public void setCurrentCallbackType(CallbackType callbackType) {
        this.currentState.callbackType = callbackType;
    }

    public void setCurrentCallbackMethods(String[] callbackMethods) {
        ControllerState.access$1702(this.currentState, callbackMethods);
    }

    public void addCallbackMethodListener(CallbackMethodListener listener) {
        this.listenerList.add(CallbackMethodListener.class, listener);
    }

    public void fireCallbackMethodEvent(CallbackMethodEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(CallbackMethodListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            CallbackMethodListener temp = (CallbackMethodListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.callbackMethodAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.callbackMethodChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.callbackMethodRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public void addEntityListenerListener(EntityListenerListener listener) {
        this.listenerList.add(EntityListenerListener.class, listener);
    }

    public void fireEntityListenerEvent(EntityListenerEvent e) {
        this.setDirty(true);
        EventListener[] list = this.listenerList.getListeners(EntityListenerListener.class);
        block5: for (int i = 0; i < list.length; ++i) {
            EntityListenerListener temp = (EntityListenerListener)list[i];
            switch (e.getId()) {
                case 2: {
                    temp.entityListenerAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.entityListenerChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.entityListenerRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public ProjectWatchdog getProjectWatcher() {
        return this.watchdog;
    }

    public Object getCurrentObject() {
        if (this.getCurrentObjEntity() != null) {
            return this.getCurrentObjEntity();
        }
        if (this.getCurrentDbEntity() != null) {
            return this.getCurrentDbEntity();
        }
        if (this.getCurrentQuery() != null) {
            return this.getCurrentQuery();
        }
        if (this.getCurrentProcedure() != null) {
            return this.getCurrentProcedure();
        }
        if (this.getCurrentDataMap() != null) {
            return this.getCurrentDataMap();
        }
        if (this.getCurrentDataNode() != null) {
            return this.getCurrentDataNode();
        }
        if (this.getCurrentDataDomain() != null) {
            return this.getCurrentDataDomain();
        }
        if (this.getCurrentPaths() != null) {
            ProjectPath[] paths = this.getCurrentPaths();
            Vector<Object> result = new Vector<Object>();
            Object parent = paths[0].getObjectParent();
            for (int i = 0; i < paths.length; ++i) {
                Object lastObject = paths[i].getObject();
                result.add(lastObject);
            }
            Collections.sort(result, parent instanceof DataMap ? Comparators.getDataMapChildrenComparator() : Comparators.getDataDomainChildrenComparator());
            return result;
        }
        return null;
    }

    public class ControllerState {
        private boolean isRefiring = false;
        private DisplayEvent event = null;
        private DataDomain domain = null;
        private DataNode node = null;
        private DataMap map = null;
        private ObjEntity objEntity = null;
        private DbEntity dbEntity = null;
        private ObjAttribute[] objAttrs;
        private DbAttribute[] dbAttrs = new DbAttribute[0];
        private ObjRelationship[] objRels;
        private DbRelationship[] dbRels = new DbRelationship[0];
        private Procedure procedure = null;
        private ProcedureParameter[] procedureParameters = new ProcedureParameter[0];
        private Query query = null;
        private ProjectPath[] paths = null;
        private String listenerClass;
        private CallbackType callbackType;
        private String[] callbackMethods;

        public ControllerState() {
            this.objAttrs = new ObjAttribute[0];
            this.objRels = new ObjRelationship[0];
            this.callbackMethods = new String[0];
        }

        public boolean isEquivalent(ControllerState val) {
            if (val == null) {
                return false;
            }
            if (this.event instanceof EntityDisplayEvent && val.event instanceof EntityDisplayEvent) {
                if (((EntityDisplayEvent)val.event).getEntity() instanceof ObjEntity) {
                    return this.objEntity == val.objEntity;
                }
                return this.dbEntity == val.dbEntity;
            }
            if (this.event instanceof ProcedureDisplayEvent && val.event instanceof ProcedureDisplayEvent) {
                return this.procedure == val.procedure;
            }
            if (this.event instanceof QueryDisplayEvent && val.event instanceof QueryDisplayEvent) {
                return this.query == val.query;
            }
            if (this.event.getClass() == DataMapDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.map == val.map;
            }
            if (this.event.getClass() == DataNodeDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.node == val.node;
            }
            if (this.event.getClass() == DomainDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.domain == val.domain;
            }
            return false;
        }

        static /* synthetic */ ProcedureParameter[] access$1302(ControllerState x0, ProcedureParameter[] x1) {
            x0.procedureParameters = x1;
            return x1;
        }

        static /* synthetic */ DbAttribute[] access$802(ControllerState x0, DbAttribute[] x1) {
            x0.dbAttrs = x1;
            return x1;
        }

        static /* synthetic */ ObjAttribute[] access$702(ControllerState x0, ObjAttribute[] x1) {
            x0.objAttrs = x1;
            return x1;
        }

        static /* synthetic */ DbRelationship[] access$1002(ControllerState x0, DbRelationship[] x1) {
            x0.dbRels = x1;
            return x1;
        }

        static /* synthetic */ ProjectPath[] access$1402(ControllerState x0, ProjectPath[] x1) {
            x0.paths = x1;
            return x1;
        }

        static /* synthetic */ ObjRelationship[] access$902(ControllerState x0, ObjRelationship[] x1) {
            x0.objRels = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1702(ControllerState x0, String[] x1) {
            x0.callbackMethods = x1;
            return x1;
        }
    }
}

