/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateProcedureAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Stored Procedure";
    }

    public CreateProcedureAction(Application application) {
        super(CreateProcedureAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        Procedure procedure = this.createProcedure(mediator.getCurrentDataMap());
        CreateProcedureAction.fireProcedureEvent(this, mediator, mediator.getCurrentDataMap(), procedure);
    }

    static void fireProcedureEvent(Object src, ProjectController mediator, DataMap dataMap, Procedure procedure) {
        mediator.fireProcedureEvent(new ProcedureEvent(src, procedure, 2));
        mediator.fireProcedureDisplayEvent(new ProcedureDisplayEvent(src, procedure, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain()));
    }

    protected Procedure createProcedure(DataMap map) {
        Procedure procedure = (Procedure)NamedObjectFactory.createObject(Procedure.class, (Object)map);
        procedure.setSchema(map.getDefaultSchema());
        map.addProcedure(procedure);
        return procedure;
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataMap.class) != null;
    }

    public String getIconName() {
        return "icon-stored-procedure.gif";
    }
}

