/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.RuntimeLoadDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.modeler.util.ModelerDbAdapter;

class ModelerProjectLoadDelegate
extends RuntimeLoadDelegate {
    public ModelerProjectLoadDelegate(Configuration configuration) {
        super(configuration, configuration.getLoadStatus());
    }

    protected void updateDefaults(DataDomain domain) {
    }

    protected void initAdapter(DataNode node, String adapterName) {
        node.setAdapter((DbAdapter)new ModelerDbAdapter(adapterName, node.getDataSource()));
    }

    public void shouldLoadDataDomain(String domainName) {
        super.shouldLoadDataDomain(domainName);
        try {
            this.findDomain(domainName).getEntityResolver().setIndexedByClass(false);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Domain is not loaded: " + domainName);
        }
    }

    public void shouldLoadDataDomainProperties(String domainName, Map properties) {
        HashMap propertiesClone = new HashMap(properties);
        Object dataContextFactory = propertiesClone.remove("cayenne.DataDomain.dataContextFactory");
        super.shouldLoadDataDomainProperties(domainName, propertiesClone);
        if (dataContextFactory != null) {
            try {
                this.findDomain(domainName).getProperties().put("cayenne.DataDomain.dataContextFactory", dataContextFactory);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Domain is not loaded: " + domainName);
            }
        }
    }

    public void finishedLoading() {
        for (DataDomain domain : this.getDomains().values()) {
            this.config.addDomain(domain);
        }
    }

    protected DataNode createDataNode(String nodeName) {
        return new DataNode(nodeName){

            public DataSource getDataSource() {
                return this.dataSource;
            }
        };
    }
}

