/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesDialog;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesModel;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.View;

public class PackageUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "cayenne.modeler.datamap.defaultprefs.package.radio";
    public static final String UNINIT_CONTROL = "cayenne.modeler.datamap.defaultprefs.packagenull.radio";
    protected boolean clientUpdate;

    public PackageUpdateController(ProjectController mediator, DataMap dataMap, boolean clientUpdate) {
        super(mediator, dataMap);
        this.clientUpdate = clientUpdate;
    }

    public void startup() {
        DefaultsPreferencesDialog view = new DefaultsPreferencesDialog(ALL_CONTROL, UNINIT_CONTROL);
        view.setTitle("Update ObjEntities Java Package");
        this.setView((View)view);
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID("cayenne.modeler.datamap.defaultprefs.update.button")) {
            this.updatePackage();
        } else {
            super.doHandleControl(control);
        }
    }

    protected void updatePackage() {
        boolean doAll = ((DefaultsPreferencesModel)this.getModel()).isAllEntities();
        String defaultPackage = this.getDefaultPackage();
        if (Util.isEmptyString((String)defaultPackage)) {
            defaultPackage = "";
        } else if (!defaultPackage.endsWith(".")) {
            defaultPackage = defaultPackage + '.';
        }
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            String oldName = this.getClassName(entity);
            if (!doAll && !Util.isEmptyString((String)oldName) && oldName.indexOf(46) >= 0) continue;
            String className = this.extractClassName(Util.isEmptyString((String)oldName) ? entity.getName() : oldName);
            this.setClassName(entity, defaultPackage + className);
        }
        this.shutdown();
    }

    protected String extractClassName(String name) {
        if (name == null) {
            return "";
        }
        int dot = name.lastIndexOf(46);
        return dot < 0 ? name : (dot + 1 < name.length() ? name.substring(dot + 1) : "");
    }

    protected String getDefaultPackage() {
        return this.clientUpdate ? this.dataMap.getDefaultClientPackage() : this.dataMap.getDefaultPackage();
    }

    protected String getClassName(ObjEntity entity) {
        return this.clientUpdate ? entity.getClientClassName() : entity.getClassName();
    }

    protected void setClassName(ObjEntity entity, String newName) {
        if (!Util.nullSafeEquals((Object)newName, (Object)this.getClassName(entity))) {
            if (this.clientUpdate) {
                entity.setClientClassName(newName);
            } else {
                entity.setClassName(newName);
            }
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity));
        }
    }
}

