/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;

public class EntityRelationshipsModel
extends BasicModel {
    static final Pattern NAME_PATTERN = Pattern.compile("\\s\\[.*\\]$");
    public static final Selector RELATIONSHIP_DISPLAY_NAME_SELECTOR = Selector.fromString((String)"relationshipDisplayName");
    protected Entity sourceEntity;
    protected String relationshipDisplayName;
    protected String defaultTargetName;
    protected Object[] relationshipNames;

    static String nameFromDisplayName(String displayName) {
        if (displayName == null) {
            return null;
        }
        return NAME_PATTERN.matcher(displayName).replaceAll("");
    }

    static String displayName(Relationship relationship) {
        if (relationship == null) {
            return null;
        }
        String src = relationship.getSourceEntity() != null ? relationship.getSourceEntity().getName() : "?";
        String target = relationship.getTargetEntityName() != null ? relationship.getTargetEntityName() : "?";
        return relationship.getName() + " [" + src + " -> " + target + "]";
    }

    public EntityRelationshipsModel(Entity sourceEntity, Entity targetEntity) {
        this.sourceEntity = sourceEntity;
        this.defaultTargetName = targetEntity.getName();
        this.relationshipDisplayName = "";
    }

    public EntityRelationshipsModel(Relationship relationship) {
        this.sourceEntity = relationship.getSourceEntity();
        this.relationshipDisplayName = EntityRelationshipsModel.displayName(relationship);
    }

    public synchronized Object[] getRelationshipNames() {
        if (this.relationshipNames == null) {
            Collection relationships = this.getSourceEntity().getRelationships();
            int size = relationships.size();
            Object[] names = new Object[size];
            Iterator it = relationships.iterator();
            for (int i = 0; i < size; ++i) {
                DbRelationship next = (DbRelationship)it.next();
                names[i] = EntityRelationshipsModel.displayName((Relationship)next);
            }
            Arrays.sort(names);
            this.relationshipNames = names;
        }
        return this.relationshipNames;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public String getRelationshipDisplayName() {
        return this.relationshipDisplayName;
    }

    public void setRelationshipDisplayName(String relationshipDisplayName) {
        if (!Util.nullSafeEquals((Object)relationshipDisplayName, (Object)this.relationshipDisplayName)) {
            this.relationshipDisplayName = relationshipDisplayName;
            this.relationshipNames = null;
            this.fireModelChange(0, RELATIONSHIP_DISPLAY_NAME_SELECTOR);
        }
    }

    public void setRelationshipName(String relationshipName) {
        this.setRelationshipDisplayName(EntityRelationshipsModel.displayName(this.sourceEntity.getRelationship(relationshipName)));
    }

    public Relationship getSelectedRelationship() {
        return this.sourceEntity.getRelationship(EntityRelationshipsModel.nameFromDisplayName(this.relationshipDisplayName));
    }

    public String getSourceEntityName() {
        return this.sourceEntity.getName();
    }

    public String getTargetEntityName() {
        Relationship selected = this.getSelectedRelationship();
        return selected != null ? selected.getTargetEntityName() : this.defaultTargetName;
    }
}

