/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjAttributeTableModel
extends CayenneTableModel {
    static final int INHERITED = 0;
    static final int OBJ_ATTRIBUTE = 1;
    static final int OBJ_ATTRIBUTE_TYPE = 2;
    static final int DB_ATTRIBUTE = 3;
    static final int DB_ATTRIBUTE_TYPE = 4;
    static final int LOCKING = 5;
    protected ObjEntity entity;
    protected DbEntity dbEntity;

    public ObjAttributeTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList(entity.getAttributes()));
        this.entity = entity;
        this.dbEntity = entity.getDbEntity();
        Collections.sort(this.objectList, new AttributeComparator());
    }

    @Override
    protected void orderList() {
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Class<?> getElementsClass() {
        return ObjAttribute.class;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public ObjAttribute getAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjAttribute)this.objectList.get(row) : null;
    }

    public void resetDbEntity() {
        if (this.dbEntity == this.entity.getDbEntity()) {
            return;
        }
        boolean wasShowing = this.isShowingDb();
        this.dbEntity = this.entity.getDbEntity();
        boolean isShowing = this.isShowingDb();
        if (wasShowing != isShowing) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    private boolean isShowingDb() {
        return this.dbEntity != null;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "In";
            }
            case 1: {
                return "ObjAttribute";
            }
            case 2: {
                return "Java Type";
            }
            case 3: {
                return "DbAttribute";
            }
            case 4: {
                return "DB Type";
            }
            case 5: {
                return "Used for Locking";
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValueAt(int row, int column) {
        int type;
        ObjAttribute attribute = this.getAttribute(row);
        if (column == 0) {
            return attribute.isInherited();
        }
        if (column == 1) {
            return attribute.getName();
        }
        if (column == 2) {
            return attribute.getType();
        }
        if (column == 5) {
            return attribute.isUsedForLocking() ? Boolean.TRUE : Boolean.FALSE;
        }
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (column == 3) {
            if (dbAttribute != null) return dbAttribute.getName();
            if (attribute.isInherited() || !((ObjEntity)attribute.getEntity()).getIsAbstract()) return null;
            return attribute.getDbAttributePath();
        }
        if (column != 4) return null;
        if (dbAttribute == null) {
            if (attribute instanceof EmbeddedAttribute) return null;
            type = TypesMapping.getSqlTypeByJava((Class)this.getAttribute(row).getJavaClass());
            return TypesMapping.getSqlNameByType((int)type);
        } else {
            type = dbAttribute.getType();
        }
        return TypesMapping.getSqlNameByType((int)type);
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjAttribute attribute = this.getAttribute(row);
        AttributeEvent event = new AttributeEvent(this.eventSource, (Attribute)attribute, (Entity)this.entity);
        if (column == 1) {
            event.setOldName(attribute.getName());
            ProjectUtil.setAttributeName((Attribute)attribute, value != null ? value.toString().trim() : null);
            this.fireTableCellUpdated(row, column);
        } else if (column == 2) {
            attribute.setType(value != null ? value.toString() : null);
            this.fireTableCellUpdated(row, column);
        } else if (column == 5) {
            attribute.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
            this.fireTableCellUpdated(row, column);
        } else {
            if (column == 3) {
                if (value != null) {
                    String path = value.toString();
                    if (this.dbEntity != null) {
                        DbAttribute dbAttribute = (DbAttribute)this.dbEntity.getAttribute(value.toString());
                        path = dbAttribute != null ? dbAttribute.getName() : null;
                    }
                    attribute.setDbAttributePath(path);
                } else if (attribute.getDbAttribute() != null) {
                    attribute.setDbAttributePath(null);
                }
            }
            this.fireTableRowsUpdated(row, row);
        }
        this.mediator.fireObjAttributeEvent(event);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.getAttribute(row).isInherited()) {
            return col == 3;
        }
        return col != 4 && col != 0;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    final class AttributeComparator
    implements Comparator {
        AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Attribute a1 = (Attribute)o1;
            Attribute a2 = (Attribute)o2;
            int delta = this.getWeight(a1) - this.getWeight(a2);
            return delta != 0 ? delta : Util.nullSafeCompare((boolean)true, (Comparable)((Object)a1.getName()), (Object)a2.getName());
        }

        private int getWeight(Attribute a) {
            return a.getEntity() == ObjAttributeTableModel.this.entity ? 1 : -1;
        }
    }
}

