/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.query.Query;

public class ObjectQueryPropertiesPanel
extends SelectPropertiesPanel {
    protected JCheckBox dataRows;

    public ObjectQueryPropertiesPanel(ProjectController mediator) {
        super(mediator);
    }

    protected void initView() {
        super.initView();
        this.dataRows = new JCheckBox();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, left:max(50dlu;pref), fill:max(150dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("", cc.xywh(1, 1, 4, 1));
        builder.addLabel("Result Caching:", cc.xy(1, 3));
        builder.add((Component)this.cacheStrategy, cc.xywh(3, 3, 2, 1));
        builder.addLabel("Fetch Data Rows:", cc.xy(1, 7));
        builder.add((Component)this.dataRows, cc.xy(3, 7));
        builder.addLabel("Fetch Offset, Rows:", cc.xy(1, 9));
        builder.add((Component)this.fetchOffset.getComponent(), cc.xy(3, 9));
        builder.addLabel("Fetch Limit, Rows:", cc.xy(1, 11));
        builder.add((Component)this.fetchLimit.getComponent(), cc.xy(3, 11));
        builder.addLabel("Page Size:", cc.xy(1, 13));
        builder.add((Component)this.pageSize.getComponent(), cc.xy(3, 13));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void initController() {
        super.initController();
        this.dataRows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Boolean b = ObjectQueryPropertiesPanel.this.dataRows.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                ObjectQueryPropertiesPanel.this.setQueryProperty("fetchingDataRows", b);
            }
        });
    }

    public void initFromModel(Query query) {
        super.initFromModel(query);
        this.dataRows.setSelected(query.getMetaData(this.mediator.getCurrentDataDomain().getEntityResolver()).isFetchingDataRows());
    }
}

