/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.dba.db2.DB2Adapter;
import org.apache.cayenne.dba.derby.DerbyAdapter;
import org.apache.cayenne.dba.frontbase.FrontBaseAdapter;
import org.apache.cayenne.dba.h2.H2Adapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.dba.ingres.IngresAdapter;
import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.dba.openbase.OpenBaseAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.postgres.PostgresAdapter;
import org.apache.cayenne.dba.sqlite.SQLiteAdapter;
import org.apache.cayenne.dba.sqlserver.SQLServerAdapter;
import org.apache.cayenne.dba.sybase.SybaseAdapter;

public class AdapterMapping {
    protected Map<String, String> adapterToJDBCDriverMap = new HashMap<String, String>();
    protected Map<String, String> adapterToJDBCURLMap = new HashMap<String, String>();
    protected Map<String, String> jdbcDriverToAdapterMap = new HashMap<String, String>();
    protected Map<String, String> eofPluginToAdapterMap = new HashMap<String, String>();

    public AdapterMapping() {
        this.initDefaults();
    }

    protected void initDefaults() {
        this.jdbcDriverToAdapterMap.put("oracle.jdbc.driver.OracleDriver", OracleAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.sybase.jdbc2.jdbc.SybDriver", SybaseAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.mysql.jdbc.Driver", MySQLAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.ibm.db2.jcc.DB2Driver", DB2Adapter.class.getName());
        this.jdbcDriverToAdapterMap.put("org.hsqldb.jdbcDriver", HSQLDBAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("org.h2.Driver", H2Adapter.class.getName());
        this.jdbcDriverToAdapterMap.put("org.postgresql.Driver", PostgresAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.openbase.jdbc.ObDriver", OpenBaseAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", SQLServerAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("org.apache.derby.jdbc.EmbeddedDriver", DerbyAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("jdbc.FrontBase.FBJDriver", FrontBaseAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("com.ingres.jdbc.IngresDriver", IngresAdapter.class.getName());
        this.jdbcDriverToAdapterMap.put("org.sqlite.JDBC", SQLiteAdapter.class.getName());
        this.adapterToJDBCURLMap.put(OracleAdapter.class.getName(), "jdbc:oracle:thin:@//localhost:1521/database");
        this.adapterToJDBCURLMap.put(SybaseAdapter.class.getName(), "jdbc:sybase:Tds:localhost:port/database");
        this.adapterToJDBCURLMap.put(MySQLAdapter.class.getName(), "jdbc:mysql://localhost/database");
        this.adapterToJDBCURLMap.put(DB2Adapter.class.getName(), "jdbc:db2://localhost:port/database");
        this.adapterToJDBCURLMap.put(HSQLDBAdapter.class.getName(), "jdbc:hsqldb:hsql://localhost/database");
        this.adapterToJDBCURLMap.put(H2Adapter.class.getName(), "jdbc:h2:mem:database;MVCC=TRUE");
        this.adapterToJDBCURLMap.put(PostgresAdapter.class.getName(), "jdbc:postgresql://localhost:5432/database");
        this.adapterToJDBCURLMap.put(OpenBaseAdapter.class.getName(), "jdbc:openbase://localhost/database");
        this.adapterToJDBCURLMap.put(SQLServerAdapter.class.getName(), "jdbc:microsoft:sqlserver://host;databaseName=database;SelectMethod=cursor");
        this.adapterToJDBCURLMap.put(SQLiteAdapter.class.getName(), "jdbc:sqlite:testdb");
        this.adapterToJDBCURLMap.put(DerbyAdapter.class.getName(), "jdbc:derby:testdb;create=true");
        this.adapterToJDBCURLMap.put(FrontBaseAdapter.class.getName(), "jdbc:FrontBase://localhost/database");
        this.adapterToJDBCURLMap.put(IngresAdapter.class.getName(), "jdbc:ingres://127.0.0.1:II7/database");
        this.adapterToJDBCDriverMap.put(OracleAdapter.class.getName(), "oracle.jdbc.driver.OracleDriver");
        this.adapterToJDBCDriverMap.put(SybaseAdapter.class.getName(), "com.sybase.jdbc2.jdbc.SybDriver");
        this.adapterToJDBCDriverMap.put(MySQLAdapter.class.getName(), "com.mysql.jdbc.Driver");
        this.adapterToJDBCDriverMap.put(DB2Adapter.class.getName(), "com.ibm.db2.jcc.DB2Driver");
        this.adapterToJDBCDriverMap.put(HSQLDBAdapter.class.getName(), "org.hsqldb.jdbcDriver");
        this.adapterToJDBCDriverMap.put(H2Adapter.class.getName(), "org.h2.Driver");
        this.adapterToJDBCDriverMap.put(PostgresAdapter.class.getName(), "org.postgresql.Driver");
        this.adapterToJDBCDriverMap.put(OpenBaseAdapter.class.getName(), "com.openbase.jdbc.ObDriver");
        this.adapterToJDBCDriverMap.put(SQLServerAdapter.class.getName(), "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        this.adapterToJDBCDriverMap.put(DerbyAdapter.class.getName(), "org.apache.derby.jdbc.EmbeddedDriver");
        this.adapterToJDBCDriverMap.put(FrontBaseAdapter.class.getName(), "jdbc.FrontBase.FBJDriver");
        this.adapterToJDBCDriverMap.put(IngresAdapter.class.getName(), "com.ingres.jdbc.IngresDriver");
        this.adapterToJDBCDriverMap.put(SQLiteAdapter.class.getName(), "org.sqlite.JDBC");
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.SybasePlugIn", SybaseAdapter.class.getName());
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.MerantPlugIn", SQLServerAdapter.class.getName());
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.MicrosoftPlugIn", SQLServerAdapter.class.getName());
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.MySQLPlugIn", MySQLAdapter.class.getName());
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.OraclePlugIn", OracleAdapter.class.getName());
        this.eofPluginToAdapterMap.put("com.webobjects.jdbcadaptor.FrontbasePlugIn", FrontBaseAdapter.class.getName());
        this.eofPluginToAdapterMap.put("PostgresqlPlugIn", PostgresAdapter.class.getName());
    }

    public String jdbcURLForAdapter(String adapterClass) {
        return this.adapterToJDBCURLMap.get(adapterClass);
    }

    public String jdbcDriverForAdapter(String adapterClass) {
        return this.adapterToJDBCDriverMap.get(adapterClass);
    }

    public String adapterForJDBCDriver(String driverClass) {
        return this.jdbcDriverToAdapterMap.get(driverClass);
    }

    public String adapterForEOFPlugin(String eofPlugin) {
        return this.eofPluginToAdapterMap.get(eofPlugin);
    }

    public String adapterForEOFPluginOrDriver(String eofPlugin, String jdbcDriver) {
        String adapter = this.adapterForEOFPlugin(eofPlugin);
        return adapter != null ? adapter : this.adapterForJDBCDriver(jdbcDriver);
    }
}

