/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 4000L;
    protected Map<String, FileInfo> filesInfo;
    protected long delay = 4000L;
    protected boolean paused;
    protected boolean singleNotification;
    private Object sync = new Object();
    private static Log log = LogFactory.getLog(FileWatchdog.class);

    protected FileWatchdog() {
        this.filesInfo = Collections.synchronizedMap(new HashMap());
        this.setDaemon(true);
    }

    public void setSingleNotification(boolean b) {
        this.singleNotification = b;
    }

    public boolean isSingleNotification() {
        return this.singleNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String location) {
        Object object = this.sync;
        synchronized (object) {
            try {
                this.filesInfo.put(location, new FileInfo(location));
            }
            catch (SecurityException e) {
                log.error((Object)("SecurityException adding file " + location), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String location) {
        Object object = this.sync;
        synchronized (object) {
            this.filesInfo.remove(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFiles() {
        Object object = this.sync;
        synchronized (object) {
            this.filesInfo.clear();
        }
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange(FileInfo var1);

    protected abstract void doOnRemove(FileInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() {
        Object object = this.sync;
        synchronized (object) {
            int i;
            if (this.paused) {
                return;
            }
            Vector<FileInfo> changed = new Vector<FileInfo>();
            Vector<FileInfo> deleted = new Vector<FileInfo>();
            Iterator<FileInfo> it = this.filesInfo.values().iterator();
            while (it.hasNext()) {
                boolean fileExists;
                FileInfo fi = it.next();
                try {
                    fileExists = fi.getFile().exists();
                }
                catch (SecurityException e) {
                    log.error((Object)("SecurityException checking file " + fi.getFile().getPath()), (Throwable)e);
                    continue;
                }
                if (fileExists) {
                    long l = fi.getFile().lastModified();
                    if (l <= fi.getLastModified()) continue;
                    fi.setLastModified(l);
                    changed.add(fi);
                    continue;
                }
                if (fi.getLastModified() == -1L) continue;
                deleted.add(fi);
                it.remove();
            }
            for (i = 0; i < deleted.size(); ++i) {
                this.doOnRemove((FileInfo)deleted.get(i));
                if (!this.singleNotification) continue;
                return;
            }
            for (i = 0; i < changed.size(); ++i) {
                this.doOnChange((FileInfo)changed.get(i));
                if (!this.singleNotification) continue;
                return;
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(this.delay);
                this.check();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWatching() {
        Object object = this.sync;
        synchronized (object) {
            this.paused = true;
        }
    }

    public void resumeWatching() {
        this.paused = false;
    }

    protected class FileInfo {
        File file;
        long lastModified;

        public FileInfo(String location) {
            this.file = new File(location);
            this.lastModified = this.file.exists() ? this.file.lastModified() : -1L;
        }

        public File getFile() {
            return this.file;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long l) {
            this.lastModified = l;
        }
    }
}

