/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Locale;
import org.apache.cayenne.access.reveng.BasicNamingStrategy;
import org.apache.cayenne.access.reveng.ExportedKey;
import org.apache.cayenne.util.NameConverter;
import org.jvnet.inflector.Noun;

public class SmartNamingStrategy
extends BasicNamingStrategy {
    public String createDbRelationshipName(ExportedKey key, boolean toMany) {
        String name;
        if (!toMany) {
            String fkColName = key.getFKColumnName();
            if (fkColName.toUpperCase().endsWith("_ID") && fkColName.length() > 3) {
                fkColName = fkColName.substring(0, fkColName.length() - 3);
            } else if (fkColName.toUpperCase().endsWith("ID") && fkColName.length() > 2) {
                fkColName = fkColName.substring(0, fkColName.length() - 2);
            } else {
                return super.createDbRelationshipName(key, toMany);
            }
            name = fkColName;
        } else {
            try {
                name = Noun.pluralOf((String)key.getFKTableName().toLowerCase(), (Locale)Locale.ENGLISH).toUpperCase();
            }
            catch (Exception inflectorError) {
                return super.createDbRelationshipName(key, toMany);
            }
        }
        return NameConverter.underscoredToJava((String)name, (boolean)false);
    }
}

