/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.ConnectionLogger;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.conn.ConnectionEventLoggingDelegate;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.modeler.util.Version;
import org.apache.cayenne.pref.CayennePreferenceService;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.hsqldb.jdbcDriver;

public class HSQLEmbeddedPreferenceService
extends CayennePreferenceService {
    protected File dbDirectory;
    protected String baseName;
    protected String masterBaseName;
    protected String cayenneConfigPackage;
    protected Configuration configuration;

    public HSQLEmbeddedPreferenceService(String dbLocation, String cayenneConfigPackage, String defaultDomain) {
        super(defaultDomain);
        if (dbLocation == null) {
            throw new PreferenceException("Null DB location.");
        }
        File file = new File(dbLocation);
        this.dbDirectory = file.getParentFile();
        this.masterBaseName = file.getName();
        this.cayenneConfigPackage = cayenneConfigPackage;
    }

    public boolean isSecondaryDB() {
        return !Util.nullSafeEquals((Object)this.masterBaseName, (Object)this.baseName);
    }

    public File getMasterLock() {
        return new File(this.dbDirectory, this.masterBaseName + ".lck");
    }

    public void startService() {
        final HSQLDataSourceFactory dataSourceFactory = new HSQLDataSourceFactory();
        DefaultConfiguration configuration = new DefaultConfiguration(){

            public DataSourceFactory getDataSourceFactory(String userFactoryName) {
                return dataSourceFactory;
            }
        };
        if (this.cayenneConfigPackage != null) {
            configuration.addClassPath(this.cayenneConfigPackage);
        }
        try {
            configuration.initialize();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error connecting to preference DB.", (Throwable)ex);
        }
        configuration.didInitialize();
        this.configuration = configuration;
        this.dataContext = configuration.getDomain().createDataContext();
        if (dataSourceFactory.needSchemaUpdate && !this.upgradeDB()) {
            this.initSchema();
        }
        this.initPreferences();
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        block9: {
            File lock;
            if (this.saveTimer != null) {
                this.saveTimer.cancel();
            }
            if (this.dataContext != null) {
                this.savePreferences();
                this.dataContext.performNonSelectingQuery((Query)new SQLTemplate(Domain.class, "SHUTDOWN"));
            }
            if (this.configuration != null) {
                this.configuration.shutdown();
            }
            if (this.isSecondaryDB() && !(lock = this.getMasterLock()).exists()) {
                try {
                    if (!lock.createNewFile()) break block9;
                    try {
                        this.moveDB(this.baseName, this.masterBaseName);
                    }
                    finally {
                        lock.delete();
                    }
                }
                catch (Throwable th) {
                    throw new PreferenceException("Error shutting down database. Preferences may be in invalid state.");
                }
            }
        }
    }

    boolean upgradeDB() {
        String versionName = this.dbDirectory.getName();
        File prefsDir = this.dbDirectory.getParentFile();
        String[] prefs = prefsDir.list();
        if (prefs == null || prefs.length == 0) {
            return false;
        }
        Version currentVersion = new Version(versionName);
        Version previousVersion = new Version("0");
        File lastDir = null;
        for (int i = 0; i < prefs.length; ++i) {
            Version v;
            File dir = new File(prefsDir, prefs[i]);
            if (!dir.isDirectory() || !new File(dir, this.baseName + ".properties").isFile()) continue;
            try {
                v = new Version(prefs[i]);
            }
            catch (NumberFormatException nfex) {
                continue;
            }
            if (v.compareTo(currentVersion) >= 0 || v.compareTo(previousVersion) <= 0) continue;
            previousVersion = v;
            lastDir = dir;
        }
        if (lastDir != null) {
            this.copyDB(lastDir, this.baseName, this.baseName);
            return true;
        }
        return false;
    }

    void moveDB(String masterBaseName, String targetBaseName) {
        File[] filesToMove = this.dbDirectory.listFiles(new HSQLDBFileFilter(masterBaseName));
        if (filesToMove != null) {
            for (int i = 0; i < filesToMove.length; ++i) {
                String ext = Util.extractFileExtension((String)filesToMove[i].getName());
                File target = new File(this.dbDirectory, targetBaseName + "." + ext);
                if (filesToMove[i].exists()) {
                    filesToMove[i].renameTo(target);
                    continue;
                }
                target.delete();
            }
        }
    }

    void copyDB(String masterBaseName, String targetBaseName) {
        this.copyDB(this.dbDirectory, masterBaseName, targetBaseName);
    }

    void copyDB(File sourceDirectory, String masterBaseName, String targetBaseName) {
        File[] filesToCopy = sourceDirectory.listFiles(new HSQLDBFileFilter(masterBaseName));
        if (filesToCopy != null) {
            for (int i = 0; i < filesToCopy.length; ++i) {
                String ext = Util.extractFileExtension((String)filesToCopy[i].getName());
                File target = new File(this.dbDirectory, targetBaseName + "." + ext);
                if (filesToCopy[i].exists()) {
                    Util.copy((File)filesToCopy[i], (File)target);
                    continue;
                }
                target.delete();
            }
        }
    }

    final class HSQLDataSourceFactory
    implements DataSourceFactory {
        boolean needSchemaUpdate;
        String url;

        HSQLDataSourceFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prepareDB() throws IOException {
            if (this.checkMainDB(HSQLEmbeddedPreferenceService.this.masterBaseName)) {
                return;
            }
            if (HSQLEmbeddedPreferenceService.this.baseName != null && this.checkMainDB(HSQLEmbeddedPreferenceService.this.baseName)) {
                return;
            }
            for (int i = 1; i < 200; ++i) {
                String name = HSQLEmbeddedPreferenceService.this.masterBaseName + i;
                File lock = new File(HSQLEmbeddedPreferenceService.this.dbDirectory, name + ".lck");
                if (lock.exists() || !lock.createNewFile()) continue;
                try {
                    HSQLEmbeddedPreferenceService.this.copyDB(HSQLEmbeddedPreferenceService.this.masterBaseName, name);
                }
                finally {
                    lock.delete();
                }
                this.needSchemaUpdate = false;
                this.url = "jdbc:hsqldb:file:" + Util.substBackslashes((String)new File(HSQLEmbeddedPreferenceService.this.dbDirectory, name).getAbsolutePath());
                HSQLEmbeddedPreferenceService.this.baseName = name;
                return;
            }
            throw new IOException("Can't create preferences DB");
        }

        boolean checkMainDB(String sessionBaseName) {
            File dbFile = new File(HSQLEmbeddedPreferenceService.this.dbDirectory, sessionBaseName + ".properties");
            if (!dbFile.exists()) {
                this.needSchemaUpdate = true;
                this.url = "jdbc:hsqldb:file:" + Util.substBackslashes((String)new File(HSQLEmbeddedPreferenceService.this.dbDirectory, sessionBaseName).getAbsolutePath());
                HSQLEmbeddedPreferenceService.this.baseName = sessionBaseName;
                return true;
            }
            File lockFile = new File(HSQLEmbeddedPreferenceService.this.dbDirectory, sessionBaseName + ".lck");
            if (lockFile.exists() && System.getProperty("os.name").toLowerCase().contains("windows")) {
                lockFile.delete();
            }
            if (!lockFile.exists()) {
                this.needSchemaUpdate = false;
                this.url = "jdbc:hsqldb:file:" + Util.substBackslashes((String)new File(HSQLEmbeddedPreferenceService.this.dbDirectory, sessionBaseName).getAbsolutePath());
                HSQLEmbeddedPreferenceService.this.baseName = sessionBaseName;
                return true;
            }
            return false;
        }

        public DataSource getDataSource(String location) throws Exception {
            try {
                this.prepareDB();
                PoolManager pm = new PoolManager(jdbcDriver.class.getName(), this.url, 1, 1, "sa", null, (ConnectionEventLoggingDelegate)new ConnectionLogger());
                return pm;
            }
            catch (Throwable th) {
                QueryLogger.logConnectFailure((Throwable)th);
                throw new PreferenceException("Error connecting to DB", th);
            }
        }

        public void initializeWithParentConfiguration(Configuration conf) {
        }
    }

    final class HSQLDBFileFilter
    implements FileFilter {
        String baseName;

        HSQLDBFileFilter(String baseName) {
            this.baseName = baseName;
        }

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fullName = pathname.getName();
            if (fullName.endsWith(".lck")) {
                return false;
            }
            int dot = fullName.indexOf(46);
            String name = dot > 0 ? fullName.substring(0, dot) : fullName;
            return this.baseName.equals(name);
        }
    }
}

