/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataChannelSyncCallbackAction
implements GraphChangeHandler {
    LifecycleCallbackRegistry callbackRegistry;
    Collection updated;
    Collection persisted;
    Collection removed;
    private Set<Object> seenIds;
    private GraphManager graphManager;

    static DataChannelSyncCallbackAction getCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 1: 
            case 2: {
                return new FlushCallbackAction(callbackRegistry, graphManager, changes);
            }
            case 3: {
                return new RollbackCallbackAction(callbackRegistry, graphManager, changes);
            }
        }
        throw new IllegalArgumentException("Unsupported sync type: " + syncType);
    }

    DataChannelSyncCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
        this.callbackRegistry = callbackRegistry;
        this.graphManager = graphManager;
        if (this.hasListeners()) {
            this.seenIds = new HashSet<Object>();
            changes.apply(this);
        }
    }

    protected abstract boolean hasListeners();

    abstract void applyPreCommit();

    abstract void applyPostCommit();

    void apply(LifecycleEvent callbackType, Collection<?> objects) {
        if (this.seenIds != null && objects != null) {
            this.callbackRegistry.performCallbacks(callbackType, objects);
        }
    }

    @Override
    public void nodeCreated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.persisted == null) {
                this.persisted = new ArrayList();
            }
            this.persisted.add(node);
        }
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.removed == null) {
                this.removed = new ArrayList();
            }
            this.removed.add(node);
        }
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.nodeUpdated(nodeId);
    }

    private void nodeUpdated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.updated == null) {
                this.updated = new ArrayList();
            }
            this.updated.add(node);
        }
    }

    static class RollbackCallbackAction
    extends DataChannelSyncCallbackAction {
        RollbackCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD);
        }

        void applyPreCommit() {
        }

        void applyPostCommit() {
            this.apply(LifecycleEvent.POST_LOAD, this.updated);
            this.apply(LifecycleEvent.POST_LOAD, this.removed);
        }
    }

    static class FlushCallbackAction
    extends DataChannelSyncCallbackAction {
        FlushCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(LifecycleEvent.PRE_UPDATE) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_UPDATE) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_REMOVE) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_PERSIST);
        }

        void applyPreCommit() {
            this.apply(LifecycleEvent.PRE_UPDATE, this.updated);
        }

        void applyPostCommit() {
            this.apply(LifecycleEvent.POST_UPDATE, this.updated);
            this.apply(LifecycleEvent.POST_REMOVE, this.removed);
            this.apply(LifecycleEvent.POST_PERSIST, this.persisted);
        }
    }
}

