/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.Compiler;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompiledExpression
implements EJBQLCompiledExpression {
    private String source;
    private String rootId;
    private Map<String, ClassDescriptor> descriptorsById;
    private Map<String, ObjRelationship> incomingById;
    private EJBQLExpression expression;
    private SQLResultSetMapping resultSetMapping;

    CompiledExpression() {
    }

    @Override
    public ClassDescriptor getEntityDescriptor(String idVariable) {
        if (idVariable == null) {
            return null;
        }
        return this.descriptorsById.get(Compiler.normalizeIdPath(idVariable));
    }

    @Override
    public SQLResultSetMapping getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public ClassDescriptor getRootDescriptor() {
        return this.rootId != null ? this.getEntityDescriptor(this.rootId) : null;
    }

    @Override
    public List<DbRelationship> getIncomingRelationships(String identifier) {
        ObjRelationship relationship = this.incomingById.get(identifier);
        if (relationship == null) {
            return Collections.emptyList();
        }
        return relationship.getDbRelationships();
    }

    @Override
    public EJBQLExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    void setExpression(EJBQLExpression expression) {
        this.expression = expression;
    }

    void setDescriptorsById(Map<String, ClassDescriptor> descriptorsById) {
        this.descriptorsById = descriptorsById;
    }

    void setIncomingById(Map<String, ObjRelationship> incomingById) {
        this.incomingById = incomingById;
    }

    void setSource(String source) {
        this.source = source;
    }

    void setRootId(String rootId) {
        this.rootId = rootId;
    }

    void setResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.resultSetMapping = resultSetMapping;
    }
}

