/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaUnitClassLoader
extends SecureClassLoader {
    JpaUnitClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/') + ".class";
        InputStream in = this.getResourceAsStream(path);
        if (in == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer, 0, 1024)) > 0) {
                out.write(buffer, 0, read);
            }
            out.close();
            byte[] classBytes = out.toByteArray();
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            return clazz;
        }
        catch (SecurityException e) {
            Class<?> clazz = super.findClass(name);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }
}

