/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.jpa.CayenneEntityManager;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.JtaEntityManager;
import org.apache.cayenne.jpa.Provider;
import org.apache.cayenne.jpa.ResourceLocalEntityManagerFactory;
import org.apache.cayenne.jpa.TypeCheckingEntityManager;

public class JtaEntityManagerFactory
extends ResourceLocalEntityManagerFactory {
    static final String TX_SYNC_REGISTRY_KEY = "java:comp/TransactionSynchronizationRegistry";
    protected TransactionSynchronizationRegistry transactionRegistry;

    JtaEntityManagerFactory(PersistenceUnitInfo unitInfo) {
        super(unitInfo);
    }

    public JtaEntityManagerFactory(Provider provider, DataDomain domain, PersistenceUnitInfo unitInfo) {
        super(provider, domain, unitInfo);
    }

    protected TransactionSynchronizationRegistry getTransactionRegistry() {
        if (this.transactionRegistry == null) {
            InitialContext jndiContext;
            try {
                jndiContext = new InitialContext();
            }
            catch (NamingException e) {
                throw new JpaProviderException("Error creating JNDI context", e);
            }
            try {
                this.transactionRegistry = (TransactionSynchronizationRegistry)jndiContext.lookup(TX_SYNC_REGISTRY_KEY);
            }
            catch (NamingException e) {
                throw new JpaProviderException("Failed to look up java:comp/TransactionSynchronizationRegistry", e);
            }
        }
        return this.transactionRegistry;
    }

    protected boolean isActiveTransaction() {
        int txStatus = this.getTransactionRegistry().getTransactionStatus();
        return txStatus == 0 || txStatus == 1;
    }

    public EntityManager createEntityManager(Map map) {
        this.checkClosed();
        CayenneEntityManager em = new JtaEntityManager(this.createObjectContext(), this);
        em = new TypeCheckingEntityManager(em);
        if (this.isActiveTransaction()) {
            em.joinTransaction();
        }
        return em;
    }
}

