/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.AttributeOverride;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;

public class JpaAttributeOverride
extends JpaAttribute {
    protected JpaColumn column;

    public JpaAttributeOverride() {
    }

    public JpaAttributeOverride(AttributeOverride annotation) {
        this.name = annotation.name();
        if (annotation.column() != null) {
            this.column = new JpaColumn(annotation.column());
        }
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<attribute-override");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        encoder.println(">");
        encoder.indent(1);
        if (this.column != null) {
            this.column.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</attribute-override>");
    }

    @TreeNodeChild
    public JpaColumn getColumn() {
        return this.column;
    }

    public void setColumn(JpaColumn column) {
        this.column = column;
    }
}

