/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.persistence.CascadeType;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCascade
implements XMLSerializable {
    protected Collection<CascadeType> cascades;

    public Collection<CascadeType> getCascades() {
        if (this.cascades == null) {
            this.cascades = new LinkedHashSet<CascadeType>(5);
        }
        return this.cascades;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        if (this.cascades != null) {
            encoder.println("<cascades>");
            encoder.indent(1);
            for (CascadeType t : this.cascades) {
                switch (t) {
                    case ALL: {
                        encoder.println("<cascade-all/>");
                        break;
                    }
                    case MERGE: {
                        encoder.println("<cascade-merge/>");
                        break;
                    }
                    case PERSIST: {
                        encoder.println("<cascade-persist/>");
                        break;
                    }
                    case REFRESH: {
                        encoder.println("<cascade-refresh/>");
                        break;
                    }
                    case REMOVE: {
                        encoder.println("<cascade-remove/>");
                    }
                }
            }
            encoder.indent(-1);
            encoder.println("</cascades>");
        }
    }

    public void setCascadeAll(Object value) {
        this.getCascades().add(CascadeType.ALL);
    }

    public void setCascadeMerge(Object value) {
        this.getCascades().add(CascadeType.MERGE);
    }

    public void setCascadePersist(Object value) {
        this.getCascades().add(CascadeType.PERSIST);
    }

    public void setCascadeRefresh(Object value) {
        this.getCascades().add(CascadeType.REFRESH);
    }

    public void setCascadeRemove(Object value) {
        this.getCascades().add(CascadeType.REMOVE);
    }
}

